/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.type.index;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.client.ClientInitializationTracker;
import io.datarouter.storage.node.DatarouterNodes;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.type.index.ManagedNode;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ManagedNodesHolder {
    @Inject
    private DatarouterNodes datarouterNodes;
    @Inject
    private ClientInitializationTracker clientInitializationTracker;
    private final Map<PhysicalDatabeanFieldInfo<?, ?, ?>, List<ManagedNode<?, ?, ?, ?, ?>>> managedNodes = new ConcurrentHashMap();

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>> List<ManagedNode<PK, D, ?, ?, ?>> getManagedNodes(PhysicalDatabeanFieldInfo<PK, D, ?> fieldInfo) {
        return this.managedNodes.computeIfAbsent(fieldInfo, $ -> new ArrayList()).stream().map(node -> node).collect(Collectors.toList());
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, N extends ManagedNode<PK, D, ?, ?, ?>> N registerManagedNode(PhysicalDatabeanFieldInfo<PK, D, ?> fieldInfo, N managedNode) {
        boolean isRegistered = this.datarouterNodes.getAllNodes().stream().map(Node::getName).anyMatch(fieldInfo.getNodeName()::equals);
        boolean isClientInitialized = this.clientInitializationTracker.isInitialized(fieldInfo.getClientId());
        if (isRegistered && isClientInitialized) {
            throw new RuntimeException(this + " is already registered and initialized, can't register index " + managedNode);
        }
        this.managedNodes.computeIfAbsent(fieldInfo, $ -> new ArrayList()).add(managedNode);
        return managedNode;
    }
}

