/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.type.index;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.index.IndexEntry;
import io.datarouter.model.index.unique.UniqueIndexEntry;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.type.index.UniqueIndexNode;
import io.datarouter.storage.op.scan.ManagedIndexIndexToDatabeanScanner;
import io.datarouter.util.tuple.Range;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class ManualUniqueIndexNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, IK extends PrimaryKey<IK>, IE extends UniqueIndexEntry<IK, IE, PK, D>>
implements UniqueIndexNode<PK, D, IK, IE> {
    private final MapStorage<PK, D> mainNode;
    private final SortedMapStorage<IK, IE> indexNode;

    public ManualUniqueIndexNode(MapStorage<PK, D> mainNode, SortedMapStorage<IK, IE> indexNode) {
        this.mainNode = mainNode;
        this.indexNode = indexNode;
    }

    @Override
    public D lookupUnique(IK uniqueKey, Config config) {
        if (uniqueKey == null) {
            return null;
        }
        UniqueIndexEntry indexEntry = (UniqueIndexEntry)this.indexNode.get(uniqueKey, config);
        if (indexEntry == null) {
            return null;
        }
        PrimaryKey primaryKey = indexEntry.getTargetKey();
        Object databean = this.mainNode.get(primaryKey, config);
        return databean;
    }

    @Override
    public List<D> lookupMultiUnique(Collection<IK> uniqueKeys, Config config) {
        if (uniqueKeys == null || uniqueKeys.isEmpty()) {
            return new LinkedList();
        }
        return (List)Scanner.of(this.indexNode.getMulti(uniqueKeys, config)).map(IndexEntry::getTargetKey).listTo(primaryKeys -> this.mainNode.getMulti((Collection<PK>)primaryKeys, config));
    }

    @Override
    public void deleteUnique(IK indexKey, Config config) {
        if (indexKey == null) {
            return;
        }
        UniqueIndexEntry indexEntry = (UniqueIndexEntry)this.indexNode.get(indexKey, config);
        if (indexEntry == null) {
            return;
        }
        PrimaryKey primaryKey = indexEntry.getTargetKey();
        this.indexNode.delete(indexKey, config);
        this.mainNode.delete(primaryKey, config);
    }

    @Override
    public void deleteMultiUnique(Collection<IK> uniqueKeys, Config config) {
        if (uniqueKeys == null || uniqueKeys.isEmpty()) {
            return;
        }
        List indexEntries = this.indexNode.getMulti(uniqueKeys, config);
        this.indexNode.deleteMulti(uniqueKeys, config);
        Scanner.of(indexEntries).map(IndexEntry::getTargetKey).flush(primaryKeys -> this.mainNode.deleteMulti((Collection<PK>)primaryKeys, config));
    }

    @Override
    public Scanner<IE> scanRanges(Collection<Range<IK>> ranges, Config config) {
        return this.indexNode.scanRanges(ranges, config);
    }

    @Override
    public Scanner<IK> scanRangesKeys(Collection<Range<IK>> ranges, Config config) {
        return this.indexNode.scanRangesKeys(ranges, config);
    }

    @Override
    public Scanner<D> scanDatabeansMulti(Collection<Range<IK>> ranges, Config config) {
        return new ManagedIndexIndexToDatabeanScanner(this.mainNode, this.scanRanges(ranges, config), config);
    }

    @Override
    public IE get(IK uniqueKey, Config config) {
        return (IE)((UniqueIndexEntry)this.indexNode.get(uniqueKey, config));
    }

    @Override
    public List<IE> getMulti(Collection<IK> uniqueKeys, Config config) {
        return this.indexNode.getMulti(uniqueKeys, config);
    }
}

