/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.op.scan.stride.internal;

import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.BaseScanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.raw.read.SortedStorageReader;
import io.datarouter.storage.op.scan.stride.internal.InternalStrideSample;
import io.datarouter.storage.op.scan.stride.internal.OffsettingStrideSample;
import io.datarouter.storage.op.scan.stride.internal.ScanningStrideSample;
import io.datarouter.util.tuple.Range;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalStrideScanner<PK extends PrimaryKey<PK>>
extends BaseScanner<InternalStrideSample<PK>> {
    private static final Logger logger = LoggerFactory.getLogger(InternalStrideScanner.class);
    private final SortedStorageReader<PK, ?> node;
    private final Supplier<Boolean> shouldStop;
    private final Range<PK> range;
    private final int stride;
    private final int batchSize;
    private final boolean log;
    private boolean striding;
    private boolean interrupted;
    private boolean finished;
    private Range<PK> nextRange;

    public InternalStrideScanner(SortedStorageReader<PK, ?> node, Supplier<Boolean> shouldStop, Range<PK> range, int stride, int batchSize, boolean log) {
        this.node = node;
        this.shouldStop = shouldStop;
        this.range = range;
        this.stride = stride;
        this.batchSize = batchSize;
        this.log = log;
        this.striding = true;
        this.interrupted = false;
        this.finished = false;
        this.nextRange = range.clone();
    }

    public boolean advance() {
        if (this.finished) {
            return false;
        }
        if (this.shouldStop.get().booleanValue()) {
            this.interrupted = true;
            this.finished = true;
        }
        this.current = null;
        if (this.striding) {
            InternalStrideScanner.nextOffsettingPk(this.node, this.nextRange, this.stride).map(offsettingSample -> offsettingSample.toStrideSample(this.nextRange, this.interrupted)).ifPresent(this::updateCurrent);
            boolean bl = this.striding = this.current != null;
        }
        if (this.current == null) {
            InternalStrideScanner.nextScanningPk(this.node, this.nextRange, this.batchSize).map(scanningSample -> scanningSample.toStrideSample(this.nextRange, this.interrupted)).ifPresent(this::updateCurrent);
            this.finished = true;
        }
        return this.current != null;
    }

    private void updateCurrent(InternalStrideSample<PK> sample) {
        this.current = sample;
        if (this.current != null) {
            this.nextRange = new Range(((InternalStrideSample)this.current).lastSeenKey, false, (Comparable)((PrimaryKey)this.range.getEnd()), this.range.getEndInclusive());
            if (this.log) {
                logger.warn("{}", this.current);
            }
        }
    }

    private static <PK extends PrimaryKey<PK>> Optional<OffsettingStrideSample<PK>> nextOffsettingPk(SortedStorageReader<PK, ?> node, Range<PK> range, int stride) {
        Config strideConfig = new Config().setLimit(1).setOffset(stride - 1);
        return node.scanKeys(range, strideConfig).findFirst().map(pk -> new OffsettingStrideSample<PrimaryKey>((PrimaryKey)pk, stride));
    }

    private static <PK extends PrimaryKey<PK>> Optional<ScanningStrideSample<PK>> nextScanningPk(SortedStorageReader<PK, ?> node, Range<PK> range, int batchSize) {
        Config scanKeysConfig = new Config().setOutputBatchSize(batchSize);
        ScanKeysState state = new ScanKeysState();
        node.scanKeys(range, scanKeysConfig).forEach(pk -> {
            scanKeysState.lastSeenKey = pk;
            ++scanKeysState.count;
        });
        if (state.count == 0L) {
            return Optional.empty();
        }
        long numRpcs = state.count / (long)batchSize;
        ScanningStrideSample sample = new ScanningStrideSample(state.lastSeenKey, numRpcs, state.count);
        return Optional.of(sample);
    }

    private static class ScanKeysState<PK extends PrimaryKey<PK>> {
        PK lastSeenKey;
        long count;

        private ScanKeysState() {
        }
    }
}

