/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.serialize.fieldcache;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.tableconfig.NodewatchConfiguration;
import io.datarouter.storage.serialize.fieldcache.DatabeanFieldInfo;
import io.datarouter.util.string.StringTool;

public class PhysicalDatabeanFieldInfo<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>>
extends DatabeanFieldInfo<PK, D, F> {
    private final ClientId clientId;
    private final String tableName;
    private final String nodeName;
    private final NodewatchConfiguration nodewatchConfiguration;
    private final boolean disableForcePrimary;

    public PhysicalDatabeanFieldInfo(NodeParams<PK, D, F> params) {
        super(params);
        this.clientId = params.getClientId();
        boolean entity = StringTool.notEmpty((String)params.getEntityNodePrefix());
        this.tableName = entity ? params.getPhysicalName() : (StringTool.notEmpty((String)params.getPhysicalName()) ? params.getPhysicalName() : ((Databean)params.getDatabeanSupplier().get()).getDatabeanName());
        String nodeName = String.valueOf(this.clientId.getName()) + "." + this.tableName;
        if (params.getEntityNodePrefix() != null) {
            nodeName = String.valueOf(nodeName) + "." + params.getEntityNodePrefix();
        }
        this.nodeName = nodeName;
        this.nodewatchConfiguration = params.getTableConfiguration();
        this.disableForcePrimary = params.getDisableForcePrimary();
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public NodewatchConfiguration getTableConfiguration() {
        return this.nodewatchConfiguration;
    }

    public boolean getDisableForcePrimary() {
        return this.disableForcePrimary;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PhysicalDatabeanFieldInfo)) {
            return false;
        }
        return this.nodeName.equals(((PhysicalDatabeanFieldInfo)obj).nodeName);
    }

    public int hashCode() {
        return this.nodeName.hashCode();
    }

    public String toString() {
        return this.nodeName;
    }
}

