/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.client;

import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientInitializationTracker;
import io.datarouter.storage.client.ClientManager;
import io.datarouter.storage.config.schema.SchemaUpdateResult;
import io.datarouter.storage.node.DatarouterNodes;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.util.concurrent.FutureTool;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.inject.Inject;

public abstract class BaseClientManager
implements ClientManager {
    @Inject
    private ClientInitializationTracker clientInitializationTracker;
    @Inject
    private DatarouterNodes datarouterNodes;

    @Override
    public boolean monitorLatency() {
        return true;
    }

    protected Future<Optional<SchemaUpdateResult>> doSchemaUpdate(PhysicalNode<?, ?, ?> node) {
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    public void doSchemaUpdate(Collection<? extends PhysicalNode<?, ?, ?>> nodes) {
        nodes.stream().map(this::doSchemaUpdate).map(FutureTool::get).flatMap(Optional::stream).map(result -> result.startupBlockReason).flatMap(Optional::stream).findFirst().ifPresent($ -> this.gatherSchemaUpdates());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void initClient(ClientId clientId) {
        if (this.clientInitializationTracker.isInitialized(clientId)) {
            return;
        }
        ClientId clientId2 = clientId;
        synchronized (clientId2) {
            if (this.clientInitializationTracker.isInitialized(clientId)) {
                return;
            }
            this.safeInitClient(clientId);
            this.clientInitializationTracker.setInitialized(clientId);
            this.doSchemaUpdate(this.datarouterNodes.getPhysicalNodesForClient(clientId.getName()));
        }
    }

    protected abstract void safeInitClient(ClientId var1);

    @Override
    public void gatherSchemaUpdates() {
    }
}

