/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.client;

import io.datarouter.inject.DatarouterInjector;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientInitMode;
import io.datarouter.storage.client.ClientInitializationTracker;
import io.datarouter.storage.client.ClientManager;
import io.datarouter.storage.client.ClientOptions;
import io.datarouter.storage.client.ClientOptionsFactory;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.client.ClientTypeRegistry;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.storage.config.executor.DatarouterStorageExecutors;
import io.datarouter.util.concurrent.FutureTool;
import io.datarouter.util.duration.DatarouterDuration;
import io.datarouter.util.properties.PropertiesTool;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.tuple.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterClients {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterClients.class);
    private final ClientTypeRegistry clientTypeRegistry;
    private final DatarouterStorageExecutors.DatarouterClientFactoryExecutor executorService;
    private final DatarouterInjector datarouterInjector;
    private final ClientOptions clientOptions;
    private final ClientInitializationTracker clientInitializationTracker;
    private final ClientOptionsFactory clientOptionsFactory;
    private final Set<String> configFilePaths;
    private final Map<String, ClientId> clientIdByClientName;

    @Inject
    public DatarouterClients(DatarouterProperties properties, ClientTypeRegistry clientTypeRegistry, DatarouterStorageExecutors.DatarouterClientFactoryExecutor executorService, DatarouterInjector datarouterInjector, ClientOptions clientOptions, ClientInitializationTracker clientInitializationTracker, ClientOptionsFactory clientOptionsFactory) {
        this.clientTypeRegistry = clientTypeRegistry;
        this.executorService = executorService;
        this.datarouterInjector = datarouterInjector;
        this.clientOptions = clientOptions;
        this.clientInitializationTracker = clientInitializationTracker;
        this.clientOptionsFactory = clientOptionsFactory;
        this.configFilePaths = new TreeSet<String>();
        this.clientIdByClientName = new TreeMap<String, ClientId>();
        this.loadClientOptions(properties.getDatarouterPropertiesFileLocation(), properties.getInternalConfigDirectory());
    }

    private void loadClientOptions(String configFilePath, String internalConfigDirectoryType) {
        Properties properties = this.clientOptionsFactory.getInternalConfigDirectoryTypeOptions(internalConfigDirectoryType);
        if (!properties.isEmpty()) {
            logger.warn("Got client properties from class {}", (Object)this.clientOptionsFactory.getClass().getCanonicalName());
            this.clientOptions.addProperties(properties);
        } else if (StringTool.notEmpty((String)configFilePath) && !this.configFilePaths.contains(configFilePath)) {
            this.configFilePaths.add(configFilePath);
            Pair propertiesAndLocation = PropertiesTool.parseAndGetLocation((String)configFilePath);
            logger.warn("Got client properties from file {}", propertiesAndLocation.getRight());
            this.clientOptions.addProperties((Properties)propertiesAndLocation.getLeft());
        }
    }

    public List<ClientId> registerClientIds(Collection<ClientId> clientIdsToAdd) {
        clientIdsToAdd.forEach(clientId -> {
            ClientId clientId2 = this.clientIdByClientName.put(clientId.getName(), (ClientId)clientId);
        });
        return clientIdsToAdd.stream().filter(this.clientInitializationTracker::isInitialized).collect(Collectors.toList());
    }

    public void initializeEagerClients() {
        this.initClientsInParallel(this.getClientNamesRequiringEagerInitialization());
    }

    public ClientType<?, ?> getClientTypeInstance(ClientId clientId) {
        String clientTypeName = this.clientOptions.getClientType(clientId);
        Objects.requireNonNull(clientTypeName, "clientType not found for clientName=" + clientId.getName());
        ClientType<?, ?> clientType = this.clientTypeRegistry.get(clientTypeName);
        Objects.requireNonNull(clientType, "implementation not found for client type=" + clientTypeName);
        return clientType;
    }

    public ClientManager getClientManager(ClientId clientId) {
        return (ClientManager)this.datarouterInjector.getInstance(this.getClientTypeInstance(clientId).getClientManagerClass());
    }

    public void shutdown() {
        for (ClientId clientId : this.clientInitializationTracker.getInitializedClients()) {
            ClientManager clientManager = this.getClientManager(clientId);
            try {
                long start = System.currentTimeMillis();
                clientManager.shutdown(clientId);
                logger.warn("shutted down client={} duration={}", (Object)clientId.getName(), (Object)DatarouterDuration.ageMs((long)start));
            }
            catch (Exception e) {
                logger.warn("swallowing exception while shutting down client=" + clientId, (Throwable)e);
            }
        }
    }

    private Collection<ClientId> getClientNamesRequiringEagerInitialization() {
        return Scanner.of(this.getClientIds()).include(clientId -> this.clientOptions.getInitMode((ClientId)clientId, ClientInitMode.lazy) == ClientInitMode.eager).list();
    }

    public ClientId getClientId(String clientName) {
        return this.clientIdByClientName.get(clientName);
    }

    public Collection<ClientId> getClientIds() {
        return this.clientIdByClientName.values();
    }

    public Map<Boolean, List<ClientId>> getClientNamesByInitialized() {
        return Scanner.of(this.getClientIds()).groupBy(this.clientInitializationTracker::isInitialized);
    }

    public void initAllClients() {
        this.initClientsInParallel(this.getClientIds());
    }

    private void initClientsInParallel(Collection<ClientId> clientIds) {
        ArrayList<Future> futures = new ArrayList<Future>();
        for (ClientId clientId : clientIds) {
            futures.add(this.executorService.submit(() -> this.getClientManager(clientId).initClient(clientId)));
        }
        futures.forEach(FutureTool::get);
    }
}

