/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config;

import io.datarouter.storage.config.environment.EnvironmentType;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.servertype.ServerTypes;
import io.datarouter.util.Require;
import io.datarouter.util.SystemTool;
import io.datarouter.util.aws.Ec2InstanceTool;
import io.datarouter.util.io.FileTool;
import io.datarouter.util.properties.PropertiesTool;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.tuple.Pair;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DatarouterProperties {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterProperties.class);
    private static final String JVM_ARG_PREFIX = "datarouter.";
    private static final String CONFIG_DIRECTORY_PROP = "config.directory";
    private static final String ENVIRONMENT = "environment";
    private static final String ENVIRONMENT_DOMAIN = "environmentDomain";
    private static final String ENVIRONMENT_TYPE = "environmentType";
    private static final String SERVER_PUBLIC_IP = "server.publicIp";
    private static final String SERVER_PRIVATE_IP = "server.privateIp";
    private static final String SERVER_NAME = "server.name";
    private static final String SERVER_TYPE = "server.type";
    private static final String SERVER_CLUSTER_DOMAINS = "server.clusterDomains";
    private static final String ADMINISTRATOR_EMAIL = "administrator.email";
    private static final String INTERNAL_CONFIG_DIRECTORY = "internalConfigDirectory";
    private static final List<String> REQUIRED_PROPERTIES = List.of("environment", "environmentType", "server.name", "server.type", "administrator.email", "internalConfigDirectory");
    private static final String BASE_CONFIG_DIRECTORY_ENV_VARIABLE = "BASE_CONFIG_DIRECTORY";
    private static final String SERVER_CONFIG_FILE_NAME = "server.properties";
    private static final String DEFAULT_BASE_CONFIG_DIRECTORY = "/etc/datarouter";
    private static final String CONFIG_DIRECTORY;
    private static final String TEST_CONFIG_DIRECTORY;
    private static String source;
    private final String webappName;
    private final String configDirectory;
    private final String testConfigDirectory;
    private final String configFileLocation;
    private final String environment;
    private final String environmentDomain;
    private final String environmentType;
    private final String serverName;
    private final ServerType serverType;
    private final String administratorEmail;
    private final String privateIp;
    private final String publicIp;
    private final Collection<String> clusterDomains;
    private final String internalConfigDirectory;
    private final Properties allComputedServerProperties;
    private Optional<Properties> propertiesFromConfigFile = Optional.empty();

    static {
        String baseConfigDirectory = System.getenv(BASE_CONFIG_DIRECTORY_ENV_VARIABLE);
        source = "environment variable";
        if (StringTool.isEmpty((String)baseConfigDirectory)) {
            baseConfigDirectory = DEFAULT_BASE_CONFIG_DIRECTORY;
            source = "default constant";
        }
        CONFIG_DIRECTORY = String.valueOf(baseConfigDirectory) + "/config";
        TEST_CONFIG_DIRECTORY = String.valueOf(baseConfigDirectory) + "/test";
    }

    protected DatarouterProperties(ServerTypes serverTypeOptions, String serviceName) {
        this(serverTypeOptions, serviceName, CONFIG_DIRECTORY, SERVER_CONFIG_FILE_NAME);
    }

    protected DatarouterProperties(ServerTypes serverTypeOptions, String serviceName, String configDirectory, String filename) {
        this(serverTypeOptions, serviceName, configDirectory, true, false, filename, true);
    }

    private DatarouterProperties(ServerTypes serverTypeOptions, String webappName, String configDirectory, boolean directoryRequired, boolean directoryFromJvmArg, String filename, boolean fileRequired) {
        boolean fileRequiredWithoutDirectoryRequired = fileRequired && !directoryRequired;
        Require.isTrue((!fileRequiredWithoutDirectoryRequired ? 1 : 0) != 0, (String)"directory is required if file is required");
        this.configDirectory = this.validateConfigDirectory(configDirectory, directoryRequired, directoryFromJvmArg);
        this.configFileLocation = this.findConfigFileLocation(filename, fileRequired);
        this.allComputedServerProperties = new Properties();
        this.webappName = webappName;
        this.testConfigDirectory = TEST_CONFIG_DIRECTORY;
        this.environment = this.findProperty(ENVIRONMENT);
        this.environmentDomain = this.findProperty(ENVIRONMENT_DOMAIN);
        this.environmentType = this.findProperty(ENVIRONMENT_TYPE, () -> EnvironmentType.DEVELOPMENT.get().getPersistentString());
        this.serverName = this.findProperty(SERVER_NAME, SystemTool::getHostname, "InetAddress.getLocalHost().getHostName()");
        this.serverType = serverTypeOptions.fromPersistentString(this.findProperty(SERVER_TYPE));
        this.administratorEmail = this.findProperty(ADMINISTRATOR_EMAIL);
        this.privateIp = this.findProperty(SERVER_PRIVATE_IP, Ec2InstanceTool::getEc2InstancePrivateIp, "http://169.254.169.254/latest/meta-data/local-ipv4");
        this.publicIp = this.findProperty(SERVER_PUBLIC_IP, Ec2InstanceTool::getEc2InstancePublicIp, "http://169.254.169.254/latest/meta-data/public-ipv4");
        this.clusterDomains = this.findClusterDomains();
        this.internalConfigDirectory = this.findProperty(INTERNAL_CONFIG_DIRECTORY);
        this.checkRequiredProperties();
    }

    private void checkRequiredProperties() {
        REQUIRED_PROPERTIES.stream().collect(Collectors.toMap(Function.identity(), this.allComputedServerProperties::getProperty)).entrySet().stream().filter(entry -> ((String)entry.getValue()).isEmpty()).peek(entry -> logger.error("Value missing for required property {}", entry.getKey())).findAny().ifPresent($ -> {
            throw new RuntimeException("One or more required properties are empty/null");
        });
    }

    private String validateConfigDirectory(String configDirectory, boolean directoryRequired, boolean directoryFromJvmArg) {
        if (configDirectory != null) {
            FileTool.createFileParents((String)(String.valueOf(configDirectory) + "/anything"));
            if (directoryFromJvmArg) {
                this.logJvmArgSource(CONFIG_DIRECTORY_PROP, configDirectory, "datarouter.config.directory");
            } else {
                this.logSource("config directory", configDirectory, source);
            }
        } else {
            Require.isTrue((!directoryRequired ? 1 : 0) != 0, (String)"config directory required but not found");
        }
        return configDirectory;
    }

    private String findConfigFileLocation(String filename, boolean fileRequired) {
        String configFileLocation = null;
        if (StringTool.isEmpty((String)filename)) {
            Require.isTrue((!fileRequired ? 1 : 0) != 0);
        } else {
            configFileLocation = String.valueOf(this.configDirectory) + "/" + filename;
            if (Files.notExists(Paths.get(configFileLocation, new String[0]), new LinkOption[0])) {
                logger.error("couldn't find config file {}", (Object)configFileLocation);
            } else {
                logger.warn("found config file {}", (Object)configFileLocation);
                try {
                    this.propertiesFromConfigFile = Optional.of(PropertiesTool.parse((String)configFileLocation));
                    this.logConfigFileProperties();
                }
                catch (Exception e) {
                    logger.error("couldn't parse config file {}", (Object)configFileLocation);
                }
            }
        }
        return configFileLocation;
    }

    private String findProperty(String propertyName) {
        return this.findProperty(propertyName, null, null);
    }

    private String findProperty(String propertyName, Supplier<String> defaultValue) {
        return this.findProperty(propertyName, defaultValue, null);
    }

    private String findProperty(String propertyName, Supplier<String> defaultValueSupplier, String defaultSource) {
        String defaultValue;
        Optional<Pair<String, String>> propertyValueBySource = this.getPropFromJvmArg(propertyName).or(() -> this.getPropFromConfigFile(propertyName));
        if (propertyValueBySource.isPresent() && !((String)propertyValueBySource.get().getLeft()).isEmpty()) {
            this.allComputedServerProperties.setProperty(propertyName, (String)propertyValueBySource.get().getLeft());
            return (String)propertyValueBySource.get().getLeft();
        }
        if (defaultValueSupplier != null && (defaultValue = defaultValueSupplier.get()) != null) {
            this.allComputedServerProperties.setProperty(propertyName, defaultValue);
            this.logSource(propertyName, defaultValue, defaultSource == null ? "default" : defaultSource);
            return defaultValue;
        }
        if (propertyValueBySource.isPresent()) {
            logger.error("found {} with empty value from {}", (Object)propertyName, propertyValueBySource.get().getRight());
        } else {
            logger.error("couldn't find " + propertyName + ", no default provided");
        }
        this.allComputedServerProperties.setProperty(propertyName, "");
        return null;
    }

    private Optional<Pair<String, String>> getPropFromConfigFile(String propertyName) {
        Optional<String> propertyValue = this.propertiesFromConfigFile.map(properties -> properties.getProperty(propertyName));
        if (propertyValue.isEmpty()) {
            return Optional.empty();
        }
        if (!propertyValue.get().isEmpty()) {
            this.logSource(propertyName, propertyValue.get(), this.configFileLocation);
        }
        return Optional.of(new Pair((Object)propertyValue.get(), (Object)this.configFileLocation));
    }

    private Optional<Pair<String, String>> getPropFromJvmArg(String jvmArg) {
        String jvmArgName = JVM_ARG_PREFIX + jvmArg;
        String jvmArgValue = System.getProperty(jvmArgName);
        if (jvmArgValue == null) {
            return Optional.empty();
        }
        if (!jvmArgValue.isEmpty()) {
            this.logJvmArgSource(jvmArg, jvmArgValue, jvmArgName);
        }
        return Optional.of(new Pair((Object)jvmArgValue, (Object)jvmArgName));
    }

    private Collection<String> findClusterDomains() {
        String propertyValue = this.findProperty(SERVER_CLUSTER_DOMAINS);
        if (StringTool.isNullOrEmptyOrWhitespace((String)propertyValue)) {
            return List.of();
        }
        return Stream.of(propertyValue.split(",")).filter(StringTool::notEmptyNorWhitespace).map(String::trim).collect(Collectors.toUnmodifiableList());
    }

    private void logConfigFileProperties() {
        Properties allProperties = this.propertiesFromConfigFile.orElseGet(Properties::new);
        allProperties.stringPropertyNames().stream().map(name -> String.valueOf(name) + "=" + allProperties.getProperty((String)name)).sorted().forEach(arg_0 -> ((Logger)logger).info(arg_0));
    }

    private void logSource(String name, String value, String source) {
        logger.warn("found {}={} from {}", new Object[]{name, value, source});
    }

    private void logJvmArgSource(String name, String value, String jvmArgName) {
        logger.warn("found {}={} from -D{} JVM arg", new Object[]{name, value, jvmArgName});
    }

    public String getServerTypeString() {
        return Optional.ofNullable(this.serverType).map(ServerType::getPersistentString).orElse(null);
    }

    public String findConfigFile(String filename) {
        String externalLocation = String.valueOf(this.configDirectory) + "/" + filename;
        if (Files.exists(Paths.get(externalLocation, new String[0]), new LinkOption[0])) {
            return externalLocation;
        }
        Objects.requireNonNull(this.internalConfigDirectory, String.valueOf(externalLocation) + " doesn't exist and " + INTERNAL_CONFIG_DIRECTORY + " property is not set");
        externalLocation = String.valueOf(this.configDirectory) + "/" + this.internalConfigDirectory + "/" + filename;
        if (Files.exists(Paths.get(externalLocation, new String[0]), new LinkOption[0])) {
            return externalLocation;
        }
        return "/config/" + this.internalConfigDirectory + "/" + filename;
    }

    public String getServerName() {
        return this.serverName;
    }

    public ServerType getServerType() {
        return this.serverType;
    }

    public String getServerPublicIp() {
        return this.publicIp;
    }

    public String getServerPrivateIp() {
        return this.privateIp;
    }

    public Collection<String> getServerClusterDomains() {
        return this.clusterDomains;
    }

    public String getAdministratorEmail() {
        return this.administratorEmail;
    }

    public String getConfigDirectory() {
        return this.configDirectory;
    }

    public String getTestConfigDirectory() {
        return this.testConfigDirectory;
    }

    public String getConfigFileLocation() {
        return this.configFileLocation;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getEnvironmentDomain() {
        return this.environmentDomain;
    }

    public String getEnvironmentType() {
        return this.environmentType;
    }

    public String getWebappName() {
        return this.webappName;
    }

    public String getFirstServerClusterDomain() {
        return this.getServerClusterDomains().stream().findFirst().orElse(null);
    }

    public String getInternalConfigDirectory() {
        return this.internalConfigDirectory;
    }

    public Properties getAllComputedServerProperties() {
        return this.allComputedServerProperties;
    }

    public abstract String getDatarouterPropertiesFileLocation();
}

