/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config;

import io.datarouter.util.enums.DatarouterEnumTool;
import io.datarouter.util.enums.IntegerEnum;
import io.datarouter.util.enums.PersistentString;
import io.datarouter.util.enums.StringEnum;
import java.util.Set;

public enum PutMethod implements IntegerEnum<PutMethod>,
StringEnum<PutMethod>
{
    SELECT_FIRST_OR_LOOK_AT_PRIMARY_KEY(20, "selectFirstOrLookAtPrimaryKey", false),
    UPDATE_OR_INSERT(20, "updateOrInsert", false),
    INSERT_OR_UPDATE(21, "insertOrUpdate", false),
    INSERT_OR_BUST(22, "insertOrBust", true),
    UPDATE_OR_BUST(23, "updateOrBust", true),
    MERGE(24, "merge", false),
    INSERT_IGNORE(25, "insertIgnore", false),
    INSERT_ON_DUPLICATE_UPDATE(26, "insertOnDuplicateUpdate", false),
    UPDATE_IGNORE(27, "updateIgnore", false);

    public static final Set<PutMethod> METHODS_TO_FLUSH_IMMEDIATELY;
    public static final PutMethod DEFAULT_PUT_METHOD;
    private int persistentInteger;
    private String persistentString;
    private boolean shouldAutoCommit;

    static {
        METHODS_TO_FLUSH_IMMEDIATELY = Set.of(UPDATE_OR_INSERT, INSERT_OR_UPDATE);
        DEFAULT_PUT_METHOD = INSERT_ON_DUPLICATE_UPDATE;
    }

    private PutMethod(int persistentInteger, String persistentString, boolean shouldAutoCommit) {
        this.persistentInteger = persistentInteger;
        this.persistentString = persistentString;
        this.shouldAutoCommit = shouldAutoCommit;
    }

    public boolean getShouldAutoCommit() {
        return this.shouldAutoCommit;
    }

    public Integer getPersistentInteger() {
        return this.persistentInteger;
    }

    public PutMethod fromPersistentInteger(Integer integer) {
        return (PutMethod)DatarouterEnumTool.getEnumFromInteger((IntegerEnum[])PutMethod.values(), (Integer)integer, null);
    }

    public String getPersistentString() {
        return this.persistentString;
    }

    public PutMethod fromPersistentString(String string) {
        return (PutMethod)DatarouterEnumTool.getEnumFromString((PersistentString[])PutMethod.values(), (String)string, null);
    }
}

