/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config.setting.impl;

import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.storage.setting.SettingNode;
import io.datarouter.storage.setting.cached.CachedSetting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterClientAvailabilitySwitchThresholdSettings
extends SettingNode {
    private final Map<String, CachedSetting<Integer>> switchThresholdByClientName = new ConcurrentHashMap<String, CachedSetting<Integer>>();

    @Inject
    public DatarouterClientAvailabilitySwitchThresholdSettings(SettingFinder finder) {
        super(finder, "datarouterStorage.availability.switchThreshold.");
    }

    public CachedSetting<Integer> getSwitchThreshold(ClientId clientId) {
        return this.switchThresholdByClientName.computeIfAbsent(clientId.getName(), name -> this.registerInteger((String)name, 0));
    }
}

