/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.file;

import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.key.primary.base.BaseRegularPrimaryKey;
import io.datarouter.util.Require;
import java.util.List;

public class PathbeanKey
extends BaseRegularPrimaryKey<PathbeanKey> {
    private String path;
    private String file;

    public List<Field<?>> getFields() {
        return List.of(new StringField(FieldKeys.path, this.path), new StringField(FieldKeys.file, this.file));
    }

    public PathbeanKey() {
    }

    public PathbeanKey(String path, String file) {
        if (path != null) {
            Require.isTrue((boolean)PathbeanKey.isValidPath(path));
        }
        this.path = path;
        if (file != null) {
            Require.isTrue((boolean)PathbeanKey.isValidFile(file));
        }
        this.file = file;
    }

    public static final boolean isValidPath(String path) {
        if (path.isEmpty()) {
            return true;
        }
        if (path.startsWith("/")) {
            return false;
        }
        if (path.contains("//")) {
            return false;
        }
        return path.endsWith("/");
    }

    public static final boolean isValidFile(String file) {
        if (file.contains("/")) {
            return false;
        }
        return file.length() != 0;
    }

    public String getPathAndFile() {
        return String.valueOf(this.path) + this.file;
    }

    public String getPath() {
        return this.path;
    }

    public String getFile() {
        return this.file;
    }

    public static class FieldKeys {
        public static final StringFieldKey path = new StringFieldKey("path");
        public static final StringFieldKey file = new StringFieldKey("file");
    }
}

