/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeTool;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.storage.serialize.fieldcache.DatabeanFieldInfo;
import io.datarouter.storage.serialize.fieldcache.PhysicalDatabeanFieldInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import javax.inject.Singleton;

@Singleton
public class DatarouterNodes {
    private final SortedSet<Node<?, ?, ?>> topLevelNodes = new ConcurrentSkipListSet();
    private final Map<String, Node<?, ?, ?>> nodeByName = new ConcurrentSkipListMap();
    private final Map<String, Map<String, PhysicalNode<?, ?, ?>>> physicalNodeByTableNameByClientName = new ConcurrentSkipListMap();

    DatarouterNodes() {
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>> N register(N node) {
        this.ensureDuplicateNamesReferToSameNode(node);
        List<Node<?, ?, ?>> nodeWithDescendants = NodeTool.getNodeAndDescendants(node);
        this.topLevelNodes.add(node);
        for (Node<?, ?, ?> nodeOrDescendant : nodeWithDescendants) {
            this.nodeByName.put(nodeOrDescendant.getName(), nodeOrDescendant);
            if (!(nodeOrDescendant instanceof PhysicalNode)) continue;
            PhysicalNode physicalNode = (PhysicalNode)nodeOrDescendant;
            String clientName = ((PhysicalDatabeanFieldInfo)physicalNode.getFieldInfo()).getClientId().getName();
            String tableName = ((PhysicalDatabeanFieldInfo)physicalNode.getFieldInfo()).getTableName();
            this.physicalNodeByTableNameByClientName.computeIfAbsent(clientName, k -> new TreeMap()).put(tableName, physicalNode);
        }
        return node;
    }

    public Collection<Node<?, ?, ?>> getAllNodes() {
        return this.nodeByName.values();
    }

    public Node<?, ?, ?> getNode(String nodeName) {
        return this.nodeByName.get(nodeName);
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, N extends Node<PK, D, ?>> N getNodeAndCast(String nodeName) {
        return (N)this.getNode(nodeName);
    }

    public Set<Class<?>> getTypesForClient(String clientName) {
        return this.nodeByName.values().stream().filter(node -> node.usesClient(clientName)).map(Node::getFieldInfo).map(DatabeanFieldInfo::getSampleDatabean).map(Object::getClass).collect(Collectors.toSet());
    }

    public Collection<PhysicalNode<?, ?, ?>> getPhysicalNodesForClient(String clientName) {
        return this.topLevelNodes.stream().map(node -> node.getPhysicalNodesForClient(clientName)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<String> getTableNamesForClient(String clientName) {
        return this.getPhysicalNodesForClient(clientName).stream().map(PhysicalNode::getFieldInfo).map(PhysicalDatabeanFieldInfo::getTableName).distinct().collect(Collectors.toList());
    }

    private void ensureDuplicateNamesReferToSameNode(Node<?, ?, ?> node) {
        String thisName = node.getName();
        Node<?, ?, ?> existingNode = this.nodeByName.get(thisName);
        if (existingNode == null || existingNode == node) {
            return;
        }
        String existingNodeSimpleName = existingNode.getClass().getSimpleName();
        throw new IllegalArgumentException("different node with this name already exists:" + thisName + "[" + existingNodeSimpleName + "].");
    }

    public PhysicalNode<?, ?, ?> getPhysicalNodeForClientAndTable(String clientName, String tableName) {
        return (PhysicalNode)this.physicalNodeByTableNameByClientName.getOrDefault(clientName, Collections.emptyMap()).get(tableName);
    }

    public Map<String, Map<String, PhysicalNode<?, ?, ?>>> getPhysicalNodeByTableNameByClientName() {
        return this.physicalNodeByTableNameByClientName;
    }

    public Node<?, ?, ?> findParent(Node<?, ?, ?> node, Class<?> requiredInterface) {
        for (Node node2 : this.topLevelNodes) {
            if (node2 == node) {
                return node;
            }
            Node<?, ?, ?> foundParent = DatarouterNodes.findParent(node, new LinkedList(List.of(node2)), requiredInterface);
            if (foundParent == null) continue;
            return foundParent;
        }
        throw new RuntimeException(node + " assignable to " + requiredInterface + " not found");
    }

    private static Node<?, ?, ?> findParent(Node<?, ?, ?> node, Deque<Node<?, ?, ?>> parents, Class<?> requiredInterface) {
        for (Node<?, ?, ?> childNode : parents.peekLast().getChildNodes()) {
            if (childNode == node) {
                Node<?, ?, ?> parent;
                while ((parent = parents.pollFirst()) != null) {
                    if (!requiredInterface.isAssignableFrom(parent.getClass())) continue;
                    return parent;
                }
                return childNode;
            }
            LinkedList parentsCopy = new LinkedList(parents);
            parentsCopy.addLast(childNode);
            Node<?, ?, ?> foundParent = DatarouterNodes.findParent(node, parentsCopy, requiredInterface);
            if (foundParent == null) continue;
            return foundParent;
        }
        return null;
    }

    public SortedSet<Node<?, ?, ?>> getTopLevelNodes() {
        return this.topLevelNodes;
    }
}

