/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.callsite;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.callsite.CallsiteRecorder;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.adapter.BaseAdapter;
import io.datarouter.storage.node.adapter.callsite.CallsiteAdapter;
import io.datarouter.util.BooleanTool;
import io.datarouter.util.lang.LineOfCode;
import java.util.Collection;
import java.util.function.Supplier;

public abstract class BaseCallsiteAdapter<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>>
extends BaseAdapter<PK, D, F, N>
implements CallsiteAdapter {
    private final Supplier<Boolean> recordCallsites;

    public BaseCallsiteAdapter(N backingNode) {
        super(backingNode);
        this.recordCallsites = backingNode.getFieldInfo().getRecordCallsite();
    }

    @Override
    public String getToStringPrefix() {
        return "CallsiteAdapter";
    }

    @Override
    public LineOfCode getCallsite() {
        if (this.recordCallsites == null || BooleanTool.isFalseOrNull((Boolean)this.recordCallsites.get())) {
            return null;
        }
        LineOfCode callsite = new LineOfCode(2);
        return callsite;
    }

    @Override
    public void recordCollectionCallsite(LineOfCode lineOfCode, long startTimeNs, Collection<?> items) {
        this.recordCallsite(lineOfCode, startTimeNs, items == null ? 0 : items.size());
    }

    @Override
    public void recordCallsite(LineOfCode lineOfCode, long startNs, int numItems) {
        if (this.recordCallsites == null || BooleanTool.isFalseOrNull((Boolean)this.recordCallsites.get())) {
            return;
        }
        LineOfCode datarouterMethod = new LineOfCode(2);
        long durationNs = System.nanoTime() - startNs;
        CallsiteRecorder.record(this.backingNode.getName(), datarouterMethod.getMethodName(), lineOfCode, numItems, durationNs);
    }
}

