/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.callsite.mixin;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.adapter.callsite.CallsiteAdapter;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.op.raw.write.MapStorageWriter;
import io.datarouter.util.lang.LineOfCode;
import java.util.Collection;

public interface MapStorageWriterCallsiteAdapterMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends MapStorage.MapStorageNode<PK, D, F>>
extends MapStorageWriter<PK, D>,
CallsiteAdapter {
    public N getBackingNode();

    @Override
    default public void put(D databean, Config config) {
        LineOfCode lineOfCode = this.getCallsite();
        long startNs = System.nanoTime();
        try {
            this.getBackingNode().put(databean, config);
        }
        finally {
            this.recordCallsite(lineOfCode, startNs, 1);
        }
    }

    @Override
    default public void putMulti(Collection<D> databeans, Config config) {
        LineOfCode lineOfCode = this.getCallsite();
        long startNs = System.nanoTime();
        try {
            this.getBackingNode().putMulti(databeans, config);
        }
        finally {
            this.recordCollectionCallsite(lineOfCode, startNs, databeans);
        }
    }

    @Override
    default public void delete(PK key, Config config) {
        LineOfCode lineOfCode = this.getCallsite();
        long startNs = System.nanoTime();
        try {
            this.getBackingNode().delete(key, config);
        }
        finally {
            this.recordCallsite(lineOfCode, startNs, 1);
        }
    }

    @Override
    default public void deleteMulti(Collection<PK> keys, Config config) {
        LineOfCode lineOfCode = this.getCallsite();
        long startNs = System.nanoTime();
        try {
            this.getBackingNode().deleteMulti(keys, config);
        }
        finally {
            this.recordCollectionCallsite(lineOfCode, startNs, keys);
        }
    }

    @Override
    default public void deleteAll(Config config) {
        LineOfCode lineOfCode = this.getCallsite();
        long startNs = System.nanoTime();
        try {
            this.getBackingNode().deleteAll(config);
        }
        finally {
            this.recordCallsite(lineOfCode, startNs, 0);
        }
    }
}

