/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.sanitization.sanitizer;

import io.datarouter.model.field.Field;
import io.datarouter.model.key.primary.PrimaryKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrimaryKeySanitizer {
    private static final Logger logger = LoggerFactory.getLogger(PrimaryKeySanitizer.class);

    public static void checkForNullPrimaryKeyValues(PrimaryKey<?> pk) {
        for (Field field : pk.getFields()) {
            if (field.getKey().getAutoGeneratedType().isGenerated() || field.getValue() != null) continue;
            String fieldName = field.getPrefixedName();
            throw new RuntimeException("null value detected for field=" + fieldName + " in PK=" + pk);
        }
    }

    public static void logForNullPrimaryKeyValues(PrimaryKey<?> pk) {
        for (Field field : pk.getFields()) {
            if (field.getValue() != null) continue;
            String fieldName = field.getPrefixedName();
            if (logger.isDebugEnabled()) {
                logger.warn("null value key={} field={}", new Object[]{pk, fieldName, new Exception()});
                continue;
            }
            logger.warn("null value key={} field={}", pk, (Object)fieldName);
        }
    }
}

