/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.builder;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.entity.base.DefaultEntityPartitioner;
import io.datarouter.model.key.primary.RegularPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.setting.DatarouterStorageSettingRoot;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.entity.DefaultEntity;
import io.datarouter.storage.node.entity.EntityNodeParams;
import io.datarouter.storage.node.factory.WideNodeFactory;
import io.datarouter.storage.node.op.NodeOps;
import io.datarouter.util.lang.ReflectionTool;
import java.util.function.Supplier;

public class WideNodeBuilder<PK extends RegularPrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private final Datarouter datarouter;
    private final WideNodeFactory wideNodeFactory;
    private final DatarouterStorageSettingRoot storageSettings;
    private final ClientId clientId;
    private final Supplier<PK> entityKeySupplier;
    private final Supplier<D> databeanSupplier;
    private final Supplier<F> fielderSupplier;
    private String tableName;
    private Integer schemaVersion;

    public WideNodeBuilder(Datarouter datarouter, WideNodeFactory wideNodeFactory, DatarouterStorageSettingRoot storageSettings, ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        this.datarouter = datarouter;
        this.wideNodeFactory = wideNodeFactory;
        this.storageSettings = storageSettings;
        this.clientId = clientId;
        this.entityKeySupplier = () -> (RegularPrimaryKey)ReflectionTool.create((Class)((Databean)databeanSupplier.get()).getKeyClass());
        this.databeanSupplier = databeanSupplier;
        this.fielderSupplier = fielderSupplier;
    }

    public WideNodeBuilder<PK, D, F> withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public WideNodeBuilder<PK, D, F> withSchemaVersion(Integer schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    public <N extends NodeOps<PK, D>> N build() {
        String databeanName = ((Databean)this.databeanSupplier.get()).getDatabeanName();
        String entityName = String.valueOf(databeanName) + "Entity";
        String entityNodePrefix = databeanName.replaceAll("[a-z]", "");
        NodeParams params = new NodeParams.NodeParamsBuilder(this.databeanSupplier, this.fielderSupplier).withClientId(this.clientId).withDiagnostics(this.storageSettings.recordCallsites).withEntity(entityName, entityNodePrefix).withParentName(entityName).withTableName(this.tableName != null ? this.tableName : databeanName).withSchemaVersion(this.schemaVersion).build();
        EntityNodeParams<PK, DefaultEntity<PK>> entityNodeParams = new EntityNodeParams<PK, DefaultEntity<PK>>(String.valueOf(this.clientId.getName()) + "." + entityName, this.entityKeySupplier, DefaultEntity.supplier(this.entityKeySupplier), DefaultEntityPartitioner::new, entityName);
        return (N)((NodeOps)this.wideNodeFactory.createSubEntity(entityNodeParams, params));
    }

    public <N extends NodeOps<PK, D>> N buildAndRegister() {
        return (N)((NodeOps)this.datarouter.register(this.build()));
    }
}

