/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.entity;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.entity.Entity;
import io.datarouter.model.key.entity.EntityKey;
import io.datarouter.model.key.primary.EntityPrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.entity.SubEntitySortedMapStorageReaderNode;
import io.datarouter.storage.serialize.fieldcache.EntityFieldInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public interface EntityNode<EK extends EntityKey<EK>, E extends Entity<EK>> {
    public String getName();

    public <PK extends EntityPrimaryKey<EK, PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> void register(SubEntitySortedMapStorageReaderNode<EK, PK, D, F> var1);

    public Collection<Node<?, ?, ?>> getSubEntityNodes();

    public List<E> getEntities(Collection<EK> var1, Config var2);

    default public List<E> getEntities(Collection<EK> entityKeys) {
        return this.getEntities(entityKeys, new Config());
    }

    default public E getEntity(EK entityKey, Config config) {
        return (E)((Entity)this.getEntities(Collections.singletonList(entityKey), config).stream().findFirst().orElse(null));
    }

    default public E getEntity(EK entityKey) {
        return this.getEntity(entityKey, new Config());
    }

    public void deleteMultiEntities(Collection<EK> var1, Config var2);

    default public void deleteMultiEntities(Collection<EK> entityKeys) {
        this.deleteMultiEntities(entityKeys, new Config());
    }

    default public void deleteEntity(EK entityKey, Config config) {
        this.deleteMultiEntities(Arrays.asList(entityKey), config);
    }

    default public void deleteEntity(EK entityKey) {
        this.deleteEntity(entityKey, new Config());
    }

    public List<EK> listEntityKeys(EK var1, boolean var2, Config var3);

    default public List<EK> listEntityKeys(EK startKey, boolean startKeyInclusive) {
        return this.listEntityKeys(startKey, startKeyInclusive, new Config());
    }

    public EntityFieldInfo<EK, E> getEntityFieldInfo();
}

