/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.factory;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.storage.client.imp.StreamClientNodeFactory;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeParams;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class StreamNodeFactory {
    private final DatarouterClients clients;

    @Inject
    public StreamNodeFactory(DatarouterClients clients) {
        this.clients = clients;
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>> N createSingleStreamNode(ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier, String streamName) {
        NodeParams params = new NodeParams.NodeParamsBuilder(databeanSupplier, fielderSupplier).withClientId(clientId).withStreamName(streamName).withTableName(streamName).build();
        StreamClientNodeFactory clientType = this.getClientType(params);
        return (N)clientType.createSingleStreamNode(params);
    }

    private StreamClientNodeFactory getClientType(NodeParams<?, ?, ?> params) {
        ClientType<?, ?> clientType = this.clients.getClientTypeInstance(params.getClientId());
        if (clientType == null) {
            throw new NullPointerException("clientType not found for clientName:" + params.getClientId().getName());
        }
        return (StreamClientNodeFactory)((Object)clientType);
    }
}

