/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.factory;

import io.datarouter.inject.DatarouterInjector;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientNodeFactory;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.storage.client.imp.TallyClientNodeFactory;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.builder.TallyNodeBuilder;
import io.datarouter.storage.node.factory.BaseNodeFactory;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TallyNodeFactory {
    @Inject
    private DatarouterInjector injector;
    @Inject
    private DatarouterClients clients;
    @Inject
    private Datarouter datarouter;

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> TallyNodeBuilder<PK, D, F> createTally(ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        return new TallyNodeBuilder(this.datarouter, this, clientId, databeanSupplier, fielderSupplier);
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>> N createTallyNode(ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier, int version, String tableName) {
        NodeParams params = new NodeParams.NodeParamsBuilder(databeanSupplier, fielderSupplier).withClientId(clientId).withSchemaVersion(version).withTableName(tableName).build();
        ClientType<?, ?> clientType = this.getClientTypeInstance(clientId);
        TallyClientNodeFactory clientFactories = (TallyClientNodeFactory)this.getClientFactories(clientType);
        return BaseNodeFactory.cast(clientFactories.createTallyNode(params));
    }

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>> N createTallyNode(NodeParams<PK, D, F> params) {
        ClientType<?, ?> clientType = this.getClientTypeInstance(params.getClientId());
        TallyClientNodeFactory clientFactories = (TallyClientNodeFactory)this.getClientFactories(clientType);
        return BaseNodeFactory.cast(clientFactories.createTallyNode(params));
    }

    private ClientType<?, ?> getClientTypeInstance(ClientId clientId) {
        return this.clients.getClientTypeInstance(clientId);
    }

    private ClientNodeFactory getClientFactories(ClientType<?, ?> clientType) {
        return (ClientNodeFactory)this.injector.getInstance(clientType.getClientNodeFactoryClass());
    }
}

