/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.op.index;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.index.IndexEntry;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.raw.read.SortedStorageReader;
import io.datarouter.storage.util.KeyRangeTool;
import io.datarouter.util.tuple.Range;
import java.util.Collection;
import java.util.Collections;

public interface IndexReader<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>>
extends SortedStorageReader<IK, IE> {
    public Scanner<D> scanDatabeansMulti(Collection<Range<IK>> var1, Config var2);

    default public Scanner<D> scanDatabeansMulti(Collection<Range<IK>> ranges) {
        return this.scanDatabeansMulti(ranges, new Config());
    }

    default public Scanner<D> scanDatabeans(Range<IK> range, Config config) {
        return this.scanDatabeansMulti(Collections.singletonList(range), config);
    }

    default public Scanner<D> scanDatabeans(Range<IK> range) {
        return this.scanDatabeans(range, new Config());
    }

    default public Scanner<D> scanDatabeans(Config config) {
        return this.scanDatabeans(Range.everything(), config);
    }

    default public Scanner<D> scanDatabeans() {
        return this.scanDatabeans(Range.everything(), new Config());
    }

    default public Scanner<D> scanDatabeansWithPrefix(IK prefix, Config config) {
        return this.scanDatabeans(KeyRangeTool.forPrefix(prefix), config);
    }

    default public Scanner<D> scanDatabeansWithPrefix(IK prefix) {
        return this.scanDatabeansWithPrefix(prefix, new Config());
    }

    default public Scanner<D> scanDatabeansWithPrefixes(Collection<IK> prefixes, Config config) {
        return this.scanDatabeansMulti(SortedStorageReader.getRangesFromPrefixes(prefixes), config);
    }

    default public Scanner<D> scanDatabeansWithPrefixes(Collection<IK> prefixes) {
        return this.scanDatabeansWithPrefixes(prefixes, new Config());
    }
}

