/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.type.indexing.base;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.BaseNode;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.op.raw.index.IndexListener;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseIndexingNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>>
extends BaseNode<PK, D, F> {
    protected final N mainNode;
    protected final List<IndexListener<PK, D>> indexListeners;

    public BaseIndexingNode(N mainNode) {
        super(new NodeParams.NodeParamsBuilder(mainNode.getFieldInfo().getDatabeanSupplier(), mainNode.getFieldInfo().getFielderSupplier()).build());
        this.mainNode = mainNode;
        this.indexListeners = new ArrayList<IndexListener<PK, D>>();
    }

    public void registerIndexListener(IndexListener<PK, D> indexListener) {
        this.indexListeners.add(indexListener);
    }

    @Override
    public final String getName() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.mainNode.getName() + "]";
    }

    @Override
    public List<PhysicalNode<PK, D, F>> getPhysicalNodes() {
        return new ArrayList(this.mainNode.getPhysicalNodes());
    }

    @Override
    public List<PhysicalNode<PK, D, F>> getPhysicalNodesForClient(String clientName) {
        return new ArrayList(this.mainNode.getPhysicalNodesForClient(clientName));
    }

    @Override
    public List<ClientId> getClientIds() {
        return this.mainNode.getClientIds();
    }

    @Override
    public boolean usesClient(String clientName) {
        return this.mainNode.usesClient(clientName);
    }

    @Override
    public List<N> getChildNodes() {
        return Scanner.ofNullable(this.mainNode).list();
    }

    public N getBackingNode() {
        return this.mainNode;
    }

    public List<IndexListener<PK, D>> getIndexNodes() {
        return this.indexListeners;
    }
}

