/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.setting;

import io.datarouter.storage.setting.DefaultSettingValue;
import io.datarouter.storage.setting.Setting;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.storage.setting.cached.CachedSetting;
import io.datarouter.storage.setting.cached.impl.BooleanCachedSetting;
import io.datarouter.storage.setting.cached.impl.CommaSeparatedStringCachedSetting;
import io.datarouter.storage.setting.cached.impl.DoubleCachedSetting;
import io.datarouter.storage.setting.cached.impl.DurationCachedSetting;
import io.datarouter.storage.setting.cached.impl.IntegerCachedSetting;
import io.datarouter.storage.setting.cached.impl.LongCachedSetting;
import io.datarouter.storage.setting.cached.impl.StringCachedSetting;
import io.datarouter.util.Require;
import io.datarouter.util.duration.DatarouterDuration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;

public abstract class SettingNode {
    private final String parentName;
    private final String name;
    private final SortedMap<String, SettingNode> children;
    private final SortedMap<String, CachedSetting<?>> settings;
    protected final SettingFinder finder;

    public SettingNode(SettingFinder finder, String name) {
        this(finder, name, SettingNode.findParentName(name));
    }

    private SettingNode(SettingFinder finder, String name, String parentName) {
        this.name = name;
        this.parentName = parentName;
        this.children = new ConcurrentSkipListMap<String, SettingNode>();
        this.settings = new ConcurrentSkipListMap();
        this.finder = finder;
    }

    public static String findParentName(String name) {
        Require.isTrue((boolean)name.endsWith("."), (String)("invalid name " + name));
        name = name.substring(0, name.lastIndexOf("."));
        if (!name.contains(".")) {
            return "";
        }
        return String.valueOf(name.substring(0, name.lastIndexOf("."))) + ".";
    }

    protected <N extends SettingNode> N registerChild(N child) {
        this.children.put(child.getName(), child);
        return child;
    }

    protected <S extends CachedSetting<?>> S register(S setting) {
        if (this.settings.containsKey(setting.getName())) {
            throw new IllegalArgumentException(String.valueOf(setting.getName()) + " has already been registered.");
        }
        this.finder.registerCachedSetting(setting);
        this.settings.put(setting.getName(), setting);
        return setting;
    }

    public Optional<SettingNode> getNodeByName(String nameParam) {
        return this.getNodeByNameRecursively(nameParam, false);
    }

    public Optional<SettingNode> getMostRecentAncestorNodeByName(String nameParam) {
        return this.getNodeByNameRecursively(nameParam, true);
    }

    private Optional<SettingNode> getNodeByNameRecursively(String nameParam, boolean stopAtMostRecentNonNullAncestor) {
        if (this.getName().equals(nameParam)) {
            return Optional.of(this);
        }
        if (this.getChildren().containsKey(nameParam) && stopAtMostRecentNonNullAncestor) {
            return Optional.of((SettingNode)this.getChildren().get(nameParam));
        }
        if (this.getSettings().containsKey(this.removeTrailingPeriod(nameParam)) && stopAtMostRecentNonNullAncestor) {
            return Optional.of(this);
        }
        String nextChildShortName = nameParam.substring(this.getName().length());
        int index = nextChildShortName.indexOf(46);
        String nextChildPath = String.valueOf(this.getName()) + nextChildShortName.substring(0, index + 1);
        if (this.getChildren().containsKey(nextChildPath)) {
            SettingNode ancestor = (SettingNode)this.getChildren().get(nextChildPath);
            Optional<SettingNode> moreRecentAncestor = ancestor.getNodeByNameRecursively(nameParam, stopAtMostRecentNonNullAncestor);
            if (stopAtMostRecentNonNullAncestor && moreRecentAncestor.isEmpty()) {
                return Optional.of(ancestor);
            }
            return moreRecentAncestor;
        }
        return Optional.empty();
    }

    private String removeTrailingPeriod(String name) {
        if (name.endsWith(".")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    public List<SettingNode> getDescendanceByName(String nameParam) {
        ArrayList<SettingNode> list = new ArrayList<SettingNode>();
        if (this.getName().equals(nameParam)) {
            list.add(this);
            return list;
        }
        String nextChildShortName = nameParam.substring(this.getName().length());
        int index = nextChildShortName.indexOf(46);
        String nextChildPath = String.valueOf(this.getName()) + nextChildShortName.substring(0, index + 1);
        if (this.getChildren().containsKey(nextChildPath)) {
            list.add(this);
            list.addAll(((SettingNode)this.getChildren().get(nextChildPath)).getDescendanceByName(nameParam));
        }
        return list;
    }

    public Setting<?> getDescendantSettingByName(String settingNameParam) {
        if (this.getSettings().containsKey(settingNameParam)) {
            return (Setting)this.getSettings().get(settingNameParam);
        }
        String nextChildShortName = settingNameParam.substring(this.getName().length());
        int index = nextChildShortName.indexOf(46);
        String nextChildPath = String.valueOf(this.getName()) + nextChildShortName.substring(0, index + 1);
        if (this.getChildren().containsKey(nextChildPath)) {
            return ((SettingNode)this.getChildren().get(nextChildPath)).getDescendantSettingByName(settingNameParam);
        }
        return null;
    }

    public List<SettingNode> getListChildren() {
        return new ArrayList<SettingNode>(this.children.values());
    }

    public ArrayList<CachedSetting<?>> getListSettings() {
        return new ArrayList(this.settings.values());
    }

    public String getShortName() {
        String shortName = this.getName().substring(this.getParentName().length());
        return shortName.substring(0, shortName.length() - 1);
    }

    public StringCachedSetting registerString(String name, String defaultValue) {
        return this.registerStrings(name, SettingNode.defaultTo(defaultValue));
    }

    public CommaSeparatedStringCachedSetting registerCommaSeparatedString(String name, Set<String> defaultValue) {
        return this.registerCommaSeparatedStrings(name, SettingNode.defaultTo(defaultValue));
    }

    public BooleanCachedSetting registerBoolean(String name, Boolean defaultValue) {
        return this.registerBooleans(name, SettingNode.defaultTo(defaultValue));
    }

    public IntegerCachedSetting registerInteger(String name, Integer defaultValue) {
        return this.registerIntegers(name, SettingNode.defaultTo(defaultValue));
    }

    public LongCachedSetting registerLong(String name, Long defaultValue) {
        return this.registerLongs(name, SettingNode.defaultTo(defaultValue));
    }

    public DoubleCachedSetting registerDouble(String name, Double defaultValue) {
        return this.registerDoubles(name, SettingNode.defaultTo(defaultValue));
    }

    public DurationCachedSetting registerDuration(String name, DatarouterDuration defaultValue) {
        return this.registerDurations(name, SettingNode.defaultTo(defaultValue));
    }

    public static <T> DefaultSettingValue<T> defaultTo(T globalDefault) {
        return new DefaultSettingValue<T>(globalDefault);
    }

    public StringCachedSetting registerStrings(String name, DefaultSettingValue<String> defaultValue) {
        return this.register(new StringCachedSetting(this.finder, String.valueOf(this.getName()) + name, defaultValue));
    }

    public CommaSeparatedStringCachedSetting registerCommaSeparatedStrings(String name, DefaultSettingValue<Set<String>> defaultValue) {
        return this.register(new CommaSeparatedStringCachedSetting(this.finder, String.valueOf(this.getName()) + name, defaultValue));
    }

    public BooleanCachedSetting registerBooleans(String name, DefaultSettingValue<Boolean> defaultValue) {
        return this.register(new BooleanCachedSetting(this.finder, String.valueOf(this.getName()) + name, defaultValue));
    }

    public IntegerCachedSetting registerIntegers(String name, DefaultSettingValue<Integer> defaultValue) {
        return this.register(new IntegerCachedSetting(this.finder, String.valueOf(this.getName()) + name, defaultValue));
    }

    public LongCachedSetting registerLongs(String name, DefaultSettingValue<Long> defaultValue) {
        return this.register(new LongCachedSetting(this.finder, String.valueOf(this.getName()) + name, defaultValue));
    }

    public DoubleCachedSetting registerDoubles(String name, DefaultSettingValue<Double> defaultValue) {
        return this.register(new DoubleCachedSetting(this.finder, String.valueOf(this.getName()) + name, defaultValue));
    }

    public DurationCachedSetting registerDurations(String name, DefaultSettingValue<DatarouterDuration> defaultValue) {
        return this.register(new DurationCachedSetting(this.finder, String.valueOf(this.getName()) + name, defaultValue));
    }

    public String getName() {
        return this.name;
    }

    public String getParentName() {
        return this.parentName;
    }

    public SortedMap<String, CachedSetting<?>> getSettings() {
        return this.settings;
    }

    public SortedMap<String, SettingNode> getChildren() {
        return this.children;
    }
}

