/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.util;

import io.datarouter.instrumentation.count.Counters;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.node.type.physical.PhysicalNode;

public class DatarouterCounters {
    public static final String PREFIX = "Datarouter";
    public static final String CLIENT_TYPE_virtual = "virtual";
    public static final String AGGREGATION_op = "op";
    public static final String AGGREGATION_client = "client";
    public static final String AGGREGATION_table = "table";
    public static final String AGGREGATION_node = "node";
    public static final String AGGREGATION_region = "region";
    public static final String AGGREGATION_client_server = "client-server";
    public static final String AGGREGATION_client_server_table = "client-server-table";
    public static final String AGGREGATION_client_server_table_region = "client-server-table-region";
    public static final String AGGREGATION_client_server_table_op = "client-server-table-op";
    public static final String AGGREGATION_client_table_server = "client-table-server";
    public static final String AGGREGATION_client_table_server_op = "client-table-server-op";

    public static void incOp(ClientType<?, ?> type, String key) {
        DatarouterCounters.incInternal(AGGREGATION_op, type, key, 1L);
    }

    public static void incNode(String key, String nodeName, long delta) {
        DatarouterCounters.incInternal(AGGREGATION_op, null, key, delta);
        String compoundKey = String.valueOf(nodeName) + " " + key;
        DatarouterCounters.incInternal(AGGREGATION_node, null, compoundKey, delta);
    }

    public static void incClientNodeCustom(ClientType<?, ?> type, String key, String clientName, String nodeName, long delta) {
        DatarouterCounters.incClient(type, key, clientName, delta);
        String compoundKey = String.valueOf(clientName) + " " + nodeName + " custom " + key;
        DatarouterCounters.incInternal(AGGREGATION_node, type, compoundKey, delta);
    }

    public static void incFromCounterAdapter(PhysicalNode<?, ?, ?> physicalNode, String key, long delta) {
        ClientType<?, ?> clientType = physicalNode.getClientType();
        String clientName = physicalNode.getClientId().getName();
        String nodeName = physicalNode.getName();
        DatarouterCounters.incClient(clientType, key, clientName, delta);
        String compoundKey = String.valueOf(clientName) + " " + nodeName + " " + key;
        DatarouterCounters.incInternal(AGGREGATION_node, clientType, compoundKey, delta);
    }

    public static void incClient(ClientType<?, ?> type, String key, String clientName, long delta) {
        DatarouterCounters.incInternal(AGGREGATION_op, type, key, delta);
        String compoundKey = String.valueOf(clientName) + " " + key;
        DatarouterCounters.incInternal(AGGREGATION_client, type, compoundKey, delta);
    }

    public static void incClientTable(ClientType<?, ?> type, String key, String clientName, String tableName, long delta) {
        DatarouterCounters.incClient(type, key, clientName, delta);
        String compoundKey = String.valueOf(clientName) + " " + tableName + " " + key;
        DatarouterCounters.incInternal(AGGREGATION_table, type, compoundKey, delta);
    }

    public static void incClientTableOpRegion(String clientTypeString, String clientName, String tableName, String opName, String regionName, long delta) {
        String compoundKey = String.valueOf(clientName) + " " + tableName + " " + opName + " " + regionName;
        DatarouterCounters.incInternalStringWithClientType(AGGREGATION_region, clientTypeString, compoundKey, delta);
    }

    private static void incInternal(String aggregationLevel, ClientType<?, ?> clientType, String key, long delta) {
        String clientTypeString = clientType != null ? clientType.getName() : CLIENT_TYPE_virtual;
        DatarouterCounters.incInternalStringWithClientType(aggregationLevel, clientTypeString, key, delta);
    }

    private static void incInternalStringWithClientType(String aggregationLevel, String clientTypeString, String key, long delta) {
        Counters.inc((String)("Datarouter " + aggregationLevel + " " + clientTypeString + " " + key), (long)delta);
    }
}

