/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.util;

import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.storage.util.PrimaryKeyPercentCodecTool;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class EncodedPrimaryKeyPercentCodec {
    public final String nodeName;
    public final Integer databeanVersion;
    public final PrimaryKey<?> primaryKey;

    public EncodedPrimaryKeyPercentCodec(String nodeName, Integer databeanVersion, PrimaryKey<?> primaryKey) {
        if (nodeName.contains(":")) {
            throw new IllegalArgumentException("nodeName cannot contain \":\"");
        }
        this.nodeName = nodeName;
        this.databeanVersion = databeanVersion;
        this.primaryKey = primaryKey;
    }

    public String getVersionedKeyString() {
        String encodedPk = PrimaryKeyPercentCodecTool.encode(this.primaryKey);
        return this.getEncodingVersion() + ":" + this.nodeName + ":" + this.databeanVersion + ":" + encodedPk;
    }

    public static List<String> getVersionedKeyStrings(String nodeName, int version, Collection<? extends PrimaryKey<?>> pks) {
        return pks.stream().filter(Objects::nonNull).map(pk -> new EncodedPrimaryKeyPercentCodec(nodeName, version, (PrimaryKey<?>)pk)).map(EncodedPrimaryKeyPercentCodec::getVersionedKeyString).collect(Collectors.toList());
    }

    public static <PK extends PrimaryKey<PK>> EncodedPrimaryKeyPercentCodec parse(String string, Class<PK> pkClass) {
        StringBuilder current = new StringBuilder();
        String[] parts = new String[3];
        int counter = 0;
        int i = 0;
        while (i < string.length()) {
            char character = string.charAt(i);
            if (character == ':') {
                parts[counter++] = current.toString();
                current = new StringBuilder();
            } else {
                current.append(character);
            }
            ++i;
        }
        if (counter != 3) {
            throw new RuntimeException("incorrect number of parts, counter=" + counter + " input=" + string);
        }
        int databeanVersion = Integer.parseInt(parts[2]);
        PK primaryKey = PrimaryKeyPercentCodecTool.decode(pkClass, current.toString());
        return new EncodedPrimaryKeyPercentCodec(parts[1], databeanVersion, (PrimaryKey<?>)primaryKey);
    }

    protected Integer getEncodingVersion() {
        return 1;
    }
}

