/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientManager;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaoClasses;
import io.datarouter.storage.dao.TestDao;
import io.datarouter.storage.node.DatarouterNodes;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class Datarouter {
    @Inject
    private DatarouterClients clients;
    @Inject
    private DatarouterNodes nodes;
    @Inject
    private DaoClasses daoClasses;

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>> N register(N node) {
        this.nodes.register(node);
        for (ClientId clientId : this.registerClientIds(node.getClientIds())) {
            ClientManager clientManager = this.clients.getClientManager(clientId);
            clientManager.doSchemaUpdate(node.getPhysicalNodesForClient(clientId.getName()));
        }
        return node;
    }

    private List<ClientId> registerClientIds(Collection<ClientId> clientIds) {
        return this.clients.registerClientIds(clientIds);
    }

    public synchronized void assertRegistered(Dao dao) {
        if (!(dao instanceof TestDao) && !this.daoClasses.get().contains(dao.getClass())) {
            throw new IllegalArgumentException("Unknown dao: " + dao.getClass().getSimpleName() + ". Please register it in DaoGroup, or have it implement TestDao if only used for tests");
        }
    }

    public void shutdown() {
        this.clients.shutdown();
    }

    public NavigableSet<PhysicalNode<?, ?, ?>> getWritableNodes() {
        return this.clients.getClientIds().stream().filter(ClientId::getWritable).map(ClientId::getName).map(this.nodes::getPhysicalNodesForClient).flatMap(Collection::stream).collect(Collectors.toCollection(TreeSet::new));
    }

    public DatarouterClients getClientPool() {
        return this.clients;
    }

    public DatarouterNodes getNodes() {
        return this.nodes;
    }
}

