/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.config.schema;

import io.datarouter.storage.config.schema.SchemaUpdateOptions;
import java.util.List;
import java.util.Properties;

public class SchemaUpdateOptionsBuilder {
    private final Properties properties = new Properties();

    public SchemaUpdateOptionsBuilder(boolean schemaUpdateEnabled) {
        this.properties.setProperty("schemaUpdate.enable", String.valueOf(schemaUpdateEnabled));
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdateExecuteCreateDatabases() {
        this.enableSchemaUpdateExecutePrefixedOption(".createDatabases");
        return this;
    }

    public SchemaUpdateOptionsBuilder disableSchemaUpdateExecuteCreateDatabases() {
        this.disableSchemaUpdateExecutePrefixedOption(".createDatabases");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdatePrintCreateDatabases() {
        this.enableSchemaUpdatePrintPrefixedOption(".createDatabases");
        return this;
    }

    public SchemaUpdateOptionsBuilder disableSchemaUpdatePrintCreateDatabases() {
        this.disableSchemaUpdatePrintPrefixedOption(".createDatabases");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdateExecuteCreateTables() {
        this.enableSchemaUpdateExecutePrefixedOption(".createTables");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdatePrintCreateTables() {
        this.enableSchemaUpdatePrintPrefixedOption(".createTables");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdateExecuteAddColumns() {
        this.enableSchemaUpdateExecutePrefixedOption(".addColumns");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdatePrintAddColumns() {
        this.enableSchemaUpdatePrintPrefixedOption(".addColumns");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdateExecuteDeleteColumns() {
        this.enableSchemaUpdateExecutePrefixedOption(".deleteColumns");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdatePrintDeleteColumns() {
        this.enableSchemaUpdatePrintPrefixedOption(".deleteColumns");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdateExecuteModifyColumns() {
        this.enableSchemaUpdateExecutePrefixedOption(".modifyColumns");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdatePrintModifyColumns() {
        this.enableSchemaUpdatePrintPrefixedOption(".modifyColumns");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdateExecuteAddIndexes() {
        this.enableSchemaUpdateExecutePrefixedOption(".addIndexes");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdatePrintAddIndexes() {
        this.enableSchemaUpdatePrintPrefixedOption(".addIndexes");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdateExecuteDropIndexes() {
        this.enableSchemaUpdateExecutePrefixedOption(".dropIndexes");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdatePrintDropIndexes() {
        this.enableSchemaUpdatePrintPrefixedOption(".dropIndexes");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdateExecuteModifyEngine() {
        this.enableSchemaUpdateExecutePrefixedOption(".modifyEngine");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdatePrintModifyEngine() {
        this.enableSchemaUpdatePrintPrefixedOption(".modifyEngine");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdateExecuteModifyRowFormat() {
        this.enableSchemaUpdateExecutePrefixedOption(".modifyRowFormat");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdatePrintModifyRowFormat() {
        this.enableSchemaUpdatePrintPrefixedOption(".modifyRowFormat");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdateExecuteModifyCharacterSetOrCollation() {
        this.enableSchemaUpdateExecutePrefixedOption(".modifyCharacterSetOrCollation");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdatePrintModifyCharacterSetOrCollation() {
        this.enableSchemaUpdatePrintPrefixedOption(".modifyCharacterSetOrCollation");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdateExecuteModifyTtl() {
        this.enableSchemaUpdateExecutePrefixedOption(".modifyTtl");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdatePrintModifyTtl() {
        this.enableSchemaUpdatePrintPrefixedOption(".modifyTtl");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdateExecuteModifyMaxVersions() {
        this.enableSchemaUpdateExecutePrefixedOption(".modifyMaxVersions");
        return this;
    }

    public SchemaUpdateOptionsBuilder enableSchemaUpdatePrintModifyMaxVersions() {
        this.enableSchemaUpdatePrintPrefixedOption(".modifyMaxVersions");
        return this;
    }

    public SchemaUpdateOptionsBuilder withSchemaUpdateExecuteIgnoreClients(List<String> clientsToIgnore) {
        String ignoreClientsOptionKey = this.makeSchemaUpdateExecutePrefixedKey(".ignoreClients");
        String clientsToIgnoreCsv = String.join((CharSequence)",", clientsToIgnore);
        this.properties.setProperty(ignoreClientsOptionKey, clientsToIgnoreCsv);
        return this;
    }

    public SchemaUpdateOptionsBuilder withSchemaUpdatePrintIgnoreClients(List<String> clientsToIgnore) {
        String ignoreClientsOptionKey = this.makeSchemaUpdatePrintPrefixedKey(".ignoreClients");
        String clientsToIgnoreCsv = String.join((CharSequence)",", clientsToIgnore);
        this.properties.setProperty(ignoreClientsOptionKey, clientsToIgnoreCsv);
        return this;
    }

    public SchemaUpdateOptionsBuilder withSchemaUpdateExecuteIgnoreTables(List<String> tablesToIgnore) {
        String ignoreTablesOptionKey = this.makeSchemaUpdateExecutePrefixedKey(".ignoreTables");
        String tablesToIgnoreCsv = String.join((CharSequence)",", tablesToIgnore);
        this.properties.setProperty(ignoreTablesOptionKey, tablesToIgnoreCsv);
        return this;
    }

    public SchemaUpdateOptionsBuilder withSchemaUpdatePrintIgnoreTables(List<String> tablesToIgnore) {
        String ignoreTablesOptionKey = this.makeSchemaUpdatePrintPrefixedKey(".ignoreTables");
        String tablesToIgnoreCsv = String.join((CharSequence)",", tablesToIgnore);
        this.properties.setProperty(ignoreTablesOptionKey, tablesToIgnoreCsv);
        return this;
    }

    public SchemaUpdateOptionsBuilder enableAllSchemaUpdateExecuteOptions() {
        SchemaUpdateOptions.ALL_SCHEMA_UPDATE_OPTIONS.forEach(this::enableSchemaUpdateExecutePrefixedOption);
        return this;
    }

    public SchemaUpdateOptionsBuilder enableAllSchemaUpdatePrintOptions() {
        SchemaUpdateOptions.ALL_SCHEMA_UPDATE_OPTIONS.forEach(this::enableSchemaUpdatePrintPrefixedOption);
        return this;
    }

    public Properties build() {
        return this.properties;
    }

    private void enableSchemaUpdateExecutePrefixedOption(String option) {
        String schemaUpdateExecutePrefixedOptionKey = this.makeSchemaUpdateExecutePrefixedKey(option);
        this.properties.setProperty(schemaUpdateExecutePrefixedOptionKey, String.valueOf(true));
    }

    private void disableSchemaUpdateExecutePrefixedOption(String option) {
        String schemaUpdateExecutePrefixedOptionKey = this.makeSchemaUpdateExecutePrefixedKey(option);
        this.properties.setProperty(schemaUpdateExecutePrefixedOptionKey, String.valueOf(false));
    }

    private void enableSchemaUpdatePrintPrefixedOption(String option) {
        String schemaUpdateExecutePrefixedOptionKey = this.makeSchemaUpdatePrintPrefixedKey(option);
        this.properties.setProperty(schemaUpdateExecutePrefixedOptionKey, String.valueOf(true));
    }

    private void disableSchemaUpdatePrintPrefixedOption(String option) {
        String schemaUpdateExecutePrefixedOptionKey = this.makeSchemaUpdatePrintPrefixedKey(option);
        this.properties.setProperty(schemaUpdateExecutePrefixedOptionKey, String.valueOf(false));
    }

    private String makeSchemaUpdateExecutePrefixedKey(String option) {
        return "schemaUpdate.execute" + option;
    }

    private String makeSchemaUpdatePrintPrefixedKey(String option) {
        return "schemaUpdate.print" + option;
    }
}

