/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.file;

import io.datarouter.scanner.Scanner;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.util.Subpath;
import io.datarouter.util.Require;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Optional;

public class Directory
implements BlobStorage<PathbeanKey, Pathbean> {
    private final BlobStorage<PathbeanKey, Pathbean> storage;
    private final Subpath subpathInStorage;

    public Directory(BlobStorage<PathbeanKey, Pathbean> storage) {
        this(storage, Subpath.empty());
    }

    public Directory(BlobStorage<PathbeanKey, Pathbean> storage, Subpath subpathInStorage) {
        this.storage = storage;
        this.subpathInStorage = subpathInStorage;
    }

    public Directory subdirectory(Subpath subpathInThisDirectory) {
        return new Directory(this.storage, this.subpathInStorage.append(subpathInThisDirectory));
    }

    @Override
    public void write(PathbeanKey key, byte[] value) {
        this.storage.write(this.prependStoragePath(key), value);
    }

    @Override
    public void write(PathbeanKey key, Iterator<byte[]> chunks) {
        this.storage.write(this.prependStoragePath(key), chunks);
    }

    @Override
    public void write(PathbeanKey key, InputStream inputStream) {
        this.storage.write(this.prependStoragePath(key), inputStream);
    }

    @Override
    public void delete(PathbeanKey key) {
        this.storage.delete(this.prependStoragePath(key));
    }

    @Override
    public void deleteAll(Subpath subpath) {
        this.storage.deleteAll(this.subpathInStorage.append(subpath));
    }

    @Override
    public String getBucket() {
        return this.storage.getBucket();
    }

    @Override
    public Subpath getRootPath() {
        return this.storage.getRootPath().append(this.subpathInStorage);
    }

    @Override
    public boolean exists(PathbeanKey key) {
        return this.storage.exists(this.prependStoragePath(key));
    }

    @Override
    public Optional<Long> length(PathbeanKey key) {
        return this.storage.length(this.prependStoragePath(key));
    }

    @Override
    public byte[] read(PathbeanKey key) {
        return this.storage.read(this.prependStoragePath(key));
    }

    @Override
    public byte[] read(PathbeanKey key, long offset, int length) {
        return this.storage.read(this.prependStoragePath(key), offset, length);
    }

    @Override
    public Scanner<PathbeanKey> scanKeys(Subpath subpath) {
        return this.storage.scanKeys(this.subpathInStorage.append(subpath)).map(this::removeStoragePath);
    }

    @Override
    public Scanner<Pathbean> scan(Subpath subpath) {
        return this.storage.scan(this.subpathInStorage.append(subpath)).map(pathbean -> new Pathbean(this.removeStoragePath((PathbeanKey)pathbean.getKey()), pathbean.getSize()));
    }

    private PathbeanKey prependStoragePath(PathbeanKey directoryKey) {
        Subpath storagePath = this.subpathInStorage.append(directoryKey.getSubpath());
        return PathbeanKey.of(storagePath, directoryKey.getFile());
    }

    private PathbeanKey removeStoragePath(PathbeanKey storageKey) {
        String storagePath = storageKey.getPath();
        Require.isTrue((boolean)storagePath.startsWith(this.subpathInStorage.toString()));
        String directoryPath = storagePath.substring(this.subpathInStorage.toString().length());
        return new PathbeanKey(directoryPath, storageKey.getFile());
    }
}

