/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.tableconfig.NodewatchConfiguration;
import io.datarouter.storage.util.Subpath;
import java.util.Optional;
import java.util.function.Supplier;

public class NodeParams<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private final ClientId clientId;
    private final String parentName;
    private final Supplier<D> databeanSupplier;
    private final String databeanName;
    private final Supplier<F> fielderSupplier;
    private final Integer schemaVersion;
    private final String physicalName;
    private final Optional<String> namespace;
    private final Subpath path;
    private final String entityNodePrefix;
    private final String remoteRouterName;
    private final String remoteNodeName;
    private final Supplier<Boolean> recordCallsites;
    private final String streamName;
    private final String queueUrl;
    private final NodewatchConfiguration nodewatchConfiguration;
    private final boolean disableForcePrimary;
    private final boolean isSystemTable;

    private NodeParams(ClientId clientId, String parentName, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier, Integer schemaVersion, String physicalName, String namespace, Subpath path, String entityNodePrefix, String remoteRouterName, String remoteNodeName, Supplier<Boolean> recordCallsites, String streamName, String queueUrl, NodewatchConfiguration nodewatchConfiguration, boolean disableForcePrimary, boolean isSystemTable) {
        this.clientId = clientId;
        this.parentName = parentName;
        this.databeanSupplier = databeanSupplier;
        this.namespace = Optional.ofNullable(namespace);
        this.path = path;
        this.databeanName = ((Databean)databeanSupplier.get()).getDatabeanName();
        this.fielderSupplier = fielderSupplier;
        this.schemaVersion = schemaVersion;
        this.physicalName = physicalName;
        this.entityNodePrefix = entityNodePrefix;
        this.remoteRouterName = remoteRouterName;
        this.remoteNodeName = remoteNodeName;
        this.recordCallsites = recordCallsites;
        this.streamName = streamName;
        this.queueUrl = queueUrl;
        this.nodewatchConfiguration = nodewatchConfiguration;
        this.disableForcePrimary = disableForcePrimary;
        this.isSystemTable = isSystemTable;
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    public String getClientName() {
        if (this.clientId == null) {
            return null;
        }
        return this.clientId.getName();
    }

    public String getParentName() {
        return this.parentName;
    }

    public Supplier<D> getDatabeanSupplier() {
        return this.databeanSupplier;
    }

    public String getDatabeanName() {
        return this.databeanName;
    }

    public Supplier<F> getFielderSupplier() {
        return this.fielderSupplier;
    }

    public Integer getSchemaVersion() {
        return this.schemaVersion;
    }

    public String getPhysicalName() {
        return this.physicalName;
    }

    public Optional<String> getNamespace() {
        return this.namespace;
    }

    public Subpath getPath() {
        return this.path;
    }

    public String getRemoteRouterName() {
        return this.remoteRouterName;
    }

    public String getRemoteNodeName() {
        return this.remoteNodeName;
    }

    public String getEntityNodePrefix() {
        return this.entityNodePrefix;
    }

    public Supplier<Boolean> getRecordCallsites() {
        return this.recordCallsites;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public NodewatchConfiguration getTableConfiguration() {
        return this.nodewatchConfiguration;
    }

    public boolean getDisableForcePrimary() {
        return this.disableForcePrimary;
    }

    public boolean getIsSystemTable() {
        return this.isSystemTable;
    }

    public static class NodeParamsBuilder<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
        private final Supplier<D> databeanSupplier;
        private final Supplier<F> fielderSupplier;
        private String parentName;
        private ClientId clientId;
        private Integer schemaVersion;
        private String physicalName;
        private String namespace;
        private Subpath path;
        private String entityNodePrefix;
        private String remoteRouterName;
        private String remoteNodeName;
        private Supplier<Boolean> recordCallsites;
        private String streamName;
        private String queueUrl;
        private NodewatchConfiguration nodewatchConfiguration;
        private boolean disableForcePrimary;
        private boolean isSystemTable;

        public NodeParamsBuilder(Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
            this.databeanSupplier = databeanSupplier;
            this.fielderSupplier = fielderSupplier;
        }

        public NodeParamsBuilder<PK, D, F> withClientId(ClientId clientId) {
            this.clientId = clientId;
            return this;
        }

        public NodeParamsBuilder<PK, D, F> withParentName(String parentName) {
            this.parentName = parentName;
            return this;
        }

        public NodeParamsBuilder<PK, D, F> withSchemaVersion(Integer schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public NodeParamsBuilder<PK, D, F> withBucketName(String physicalName) {
            this.physicalName = physicalName;
            return this;
        }

        public NodeParamsBuilder<PK, D, F> withTableName(String physicalName) {
            this.physicalName = physicalName;
            return this;
        }

        public NodeParamsBuilder<PK, D, F> withEntity(String entityTableName, String entityNodePrefix) {
            this.physicalName = entityTableName;
            this.entityNodePrefix = entityNodePrefix;
            return this;
        }

        public NodeParamsBuilder<PK, D, F> withDiagnostics(Supplier<Boolean> recordCallsites) {
            this.recordCallsites = recordCallsites;
            return this;
        }

        public NodeParamsBuilder<PK, D, F> withNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public NodeParamsBuilder<PK, D, F> withPath(Subpath path) {
            this.path = path;
            return this;
        }

        public NodeParamsBuilder<PK, D, F> withStreamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public NodeParamsBuilder<PK, D, F> withQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
            return this;
        }

        public NodeParamsBuilder<PK, D, F> withTableConfiguration(NodewatchConfiguration nodewatchConfiguration) {
            this.nodewatchConfiguration = nodewatchConfiguration;
            return this;
        }

        public NodeParamsBuilder<PK, D, F> withDisableForcePrimary(boolean disableForcePrimary) {
            this.disableForcePrimary = disableForcePrimary;
            return this;
        }

        public NodeParamsBuilder<PK, D, F> withIsSystemTable(boolean isSystemTable) {
            this.isSystemTable = isSystemTable;
            return this;
        }

        public NodeParams<PK, D, F> build() {
            return new NodeParams(this.clientId, this.parentName, this.databeanSupplier, this.fielderSupplier, this.schemaVersion, this.physicalName, this.namespace, this.path, this.entityNodePrefix, this.remoteRouterName, this.remoteNodeName, this.recordCallsites, this.streamName, this.queueUrl, this.nodewatchConfiguration, this.disableForcePrimary, this.isSystemTable);
        }
    }
}

