/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.Node;
import io.datarouter.storage.node.type.physical.PhysicalNode;
import io.datarouter.storage.serialize.fieldcache.DatabeanFieldInfo;
import java.util.List;

public abstract class BaseAdapter<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends Node<PK, D, F>>
implements Node<PK, D, F> {
    protected final N backingNode;

    public BaseAdapter(N backingNode) {
        this.backingNode = backingNode;
    }

    @Override
    public String getName() {
        return this.backingNode.getName();
    }

    @Override
    public DatabeanFieldInfo<PK, D, F> getFieldInfo() {
        return this.backingNode.getFieldInfo();
    }

    @Override
    public List<ClientId> getClientIds() {
        return this.backingNode.getClientIds();
    }

    @Override
    public boolean usesClient(String clientName) {
        return this.backingNode.usesClient(clientName);
    }

    @Override
    public List<? extends PhysicalNode<PK, D, F>> getPhysicalNodes() {
        return this.backingNode.getPhysicalNodes();
    }

    @Override
    public List<? extends PhysicalNode<PK, D, F>> getPhysicalNodesForClient(String clientName) {
        return this.backingNode.getPhysicalNodesForClient(clientName);
    }

    @Override
    public List<? extends Node<PK, D, F>> getChildNodes() {
        return this.backingNode.getChildNodes();
    }

    @Override
    public int compareTo(Node<PK, D, F> that) {
        return this.backingNode.compareTo(that);
    }

    public N getBackingNode() {
        return this.backingNode;
    }

    public N getUnderlyingNode() {
        if (this.backingNode instanceof BaseAdapter) {
            BaseAdapter baseAdapter = (BaseAdapter)this.getBackingNode();
            return baseAdapter.getUnderlyingNode();
        }
        return this.backingNode;
    }

    public String toString() {
        return String.valueOf(this.getToStringPrefix()) + "[" + this.backingNode.toString() + "]";
    }

    protected abstract String getToStringPrefix();
}

