/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.adapter.counter.mixin;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.index.IndexEntry;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.key.unique.UniqueKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.adapter.counter.CounterAdapter;
import io.datarouter.storage.node.op.raw.IndexedStorage;
import io.datarouter.storage.node.type.index.ManagedNode;
import io.datarouter.storage.serialize.fieldcache.IndexEntryFieldInfo;
import io.datarouter.util.tuple.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public interface IndexedStorageCounterAdapterMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends IndexedStorage.IndexedStorageNode<PK, D, F>>
extends IndexedStorage<PK, D>,
CounterAdapter<PK, D, F, N> {
    @Override
    default public D lookupUnique(UniqueKey<PK> uniqueKey, Config config) {
        String opName = "lookupUnique";
        this.getCounter().count(opName);
        Object result = ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).lookupUnique(uniqueKey, config);
        String hitOrMiss = result != null ? "hit" : "miss";
        this.getCounter().count(String.valueOf(opName) + " " + hitOrMiss);
        return result;
    }

    @Override
    default public List<D> lookupMultiUnique(Collection<? extends UniqueKey<PK>> uniqueKeys, Config config) {
        if (uniqueKeys == null || uniqueKeys.isEmpty()) {
            return new ArrayList();
        }
        String opName = "lookupMultiUnique";
        this.getCounter().count(opName);
        List results = ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).lookupMultiUnique(uniqueKeys, config);
        int numAttempts = uniqueKeys.size();
        int numHits = results.size();
        int numMisses = numAttempts - numHits;
        this.getCounter().count(String.valueOf(opName) + " attempts", numAttempts);
        this.getCounter().count(String.valueOf(opName) + " hits", numHits);
        this.getCounter().count(String.valueOf(opName) + " misses", numMisses);
        return results;
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> List<IE> getMultiFromIndex(Collection<IK> indexKeys, Config config, IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo) {
        String opName = "getFromIndex";
        this.getCounter().count(opName);
        this.getCounter().count(String.valueOf(opName) + " indexKeys", indexKeys.size());
        List<IE> results = ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).getMultiFromIndex(indexKeys, config, indexEntryFieldInfo);
        int numRows = results.size();
        this.getCounter().count(String.valueOf(opName) + " rows", numRows);
        if (numRows == 0) {
            this.getCounter().count(String.valueOf(opName) + " misses");
        }
        return results;
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> List<D> getMultiByIndex(Collection<IK> indexKeys, Config config, IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo) {
        String opName = "getByIndex";
        this.getCounter().count(opName);
        this.getCounter().count(String.valueOf(opName) + " indexKeys", indexKeys.size());
        List results = ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).getMultiByIndex(indexKeys, config, indexEntryFieldInfo);
        int numRows = results.size();
        this.getCounter().count(String.valueOf(opName) + " rows", numRows);
        if (numRows == 0) {
            this.getCounter().count(String.valueOf(opName) + " misses");
        }
        return results;
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> Scanner<IE> scanRangesIndex(IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo, Collection<Range<IK>> ranges, Config config) {
        String opName = "scanIndex";
        this.getCounter().count(opName);
        this.getCounter().count(String.valueOf(opName) + " ranges", ranges.size());
        return ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).scanRangesIndex(indexEntryFieldInfo, ranges, config);
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> Scanner<D> scanRangesByIndex(IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo, Collection<Range<IK>> ranges, Config config) {
        String opName = "scanByIndex";
        this.getCounter().count(opName);
        this.getCounter().count(String.valueOf(opName) + " ranges", ranges.size());
        return ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).scanRangesByIndex(indexEntryFieldInfo, ranges, config);
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> Scanner<IK> scanRangesIndexKeys(IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo, Collection<Range<IK>> ranges, Config config) {
        String opName = "scanIndexKeys";
        this.getCounter().count(opName);
        this.getCounter().count(String.valueOf(opName) + " ranges", ranges.size());
        return ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).scanRangesIndexKeys(indexEntryFieldInfo, ranges, config);
    }

    @Override
    default public void deleteUnique(UniqueKey<PK> uniqueKey, Config config) {
        String opName = "deleteUnique";
        this.getCounter().count(opName);
        ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).deleteUnique(uniqueKey, config);
    }

    @Override
    default public void deleteMultiUnique(Collection<? extends UniqueKey<PK>> uniqueKeys, Config config) {
        String opName = "deleteMultiUnique";
        this.getCounter().count(opName);
        this.getCounter().count(String.valueOf(opName) + " uniqueKeys", uniqueKeys.size());
        ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).deleteMultiUnique(uniqueKeys, config);
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>> void deleteByIndex(Collection<IK> indexKeys, Config config, IndexEntryFieldInfo<IK, IE, IF> indexEntryFieldInfo) {
        String opName = "deleteByIndex";
        this.getCounter().count(opName);
        this.getCounter().count(String.valueOf(opName) + " indexKeys", indexKeys.size());
        ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).deleteByIndex(indexKeys, config, indexEntryFieldInfo);
    }

    @Override
    default public <IK extends PrimaryKey<IK>, IE extends IndexEntry<IK, IE, PK, D>, IF extends DatabeanFielder<IK, IE>, MN extends ManagedNode<PK, D, IK, IE, IF>> MN registerManaged(MN managedNode) {
        return ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).registerManaged(managedNode);
    }

    @Override
    default public List<ManagedNode<PK, D, ?, ?, ?>> getManagedNodes() {
        return ((IndexedStorage.IndexedStorageNode)this.getBackingNode()).getManagedNodes();
    }
}

