/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.builder;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.node.factory.TallyNodeFactory;
import io.datarouter.storage.node.op.NodeOps;
import java.util.function.Supplier;

public class TallyNodeBuilder<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private final Datarouter datarouter;
    private final TallyNodeFactory nodeFactory;
    private final ClientId clientId;
    private final Supplier<D> databeanSupplier;
    private final Supplier<F> fielderSupplier;
    private int version;
    private String tableName;
    private boolean isSystemTable;

    public TallyNodeBuilder(Datarouter datarouter, TallyNodeFactory nodeFactory, ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        this.datarouter = datarouter;
        this.nodeFactory = nodeFactory;
        this.clientId = clientId;
        this.databeanSupplier = databeanSupplier;
        this.fielderSupplier = fielderSupplier;
    }

    public TallyNodeBuilder<PK, D, F> withSchemaVersion(int version) {
        this.version = version;
        return this;
    }

    public TallyNodeBuilder<PK, D, F> withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TallyNodeBuilder<PK, D, F> withIsSystemTable(boolean isSystemTable) {
        this.isSystemTable = isSystemTable;
        return this;
    }

    public <N extends NodeOps<PK, D>> N build() {
        return (N)((NodeOps)this.nodeFactory.createTallyNode(this.clientId, this.databeanSupplier, this.fielderSupplier, this.version, this.tableName, this.isSystemTable));
    }

    public <N extends NodeOps<PK, D>> N buildAndRegister() {
        return (N)((NodeOps)this.datarouter.register(this.build()));
    }
}

