/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.factory;

import io.datarouter.inject.DatarouterInjector;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.client.ClientType;
import io.datarouter.storage.client.DatarouterClients;
import io.datarouter.storage.client.imp.BlobClientNodeFactory;
import io.datarouter.storage.file.Pathbean;
import io.datarouter.storage.file.PathbeanKey;
import io.datarouter.storage.node.NodeParams;
import io.datarouter.storage.node.builder.BlobNodeBuilder;
import io.datarouter.storage.node.factory.BaseNodeFactory;
import io.datarouter.storage.node.op.raw.BlobStorage;
import io.datarouter.storage.util.Subpath;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class BlobNodeFactory {
    @Inject
    private DatarouterInjector injector;
    @Inject
    private Datarouter datarouter;
    @Inject
    private DatarouterClients clients;

    public <PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> BlobNodeBuilder<PK, D, F> create(ClientId clientId, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        return new BlobNodeBuilder(this.datarouter, this, clientId, databeanSupplier, fielderSupplier);
    }

    public <PK extends PrimaryKey<PK>, N extends BlobStorage.PhysicalBlobStorageNode<PathbeanKey, Pathbean, Pathbean.PathbeanFielder>> N create(ClientId clientId, String bucketName, Subpath path) {
        NodeParams params = new NodeParams.NodeParamsBuilder(Pathbean::new, Pathbean.PathbeanFielder::new).withClientId(clientId).withBucketName(bucketName).withPath(path).build();
        ClientType<?, ?> clientType = this.clients.getClientTypeInstance(clientId);
        BlobClientNodeFactory clientFactories = this.getClientFactories(clientType);
        return (N)((BlobStorage.PhysicalBlobStorageNode)BaseNodeFactory.cast(clientFactories.createBlobNode(params)));
    }

    public BlobStorage.PhysicalBlobStorageNode<PathbeanKey, Pathbean, Pathbean.PathbeanFielder> createSubdirectory(BlobStorage.PhysicalBlobStorageNode<PathbeanKey, Pathbean, Pathbean.PathbeanFielder> node, Subpath subdirectoryPath) {
        Subpath fullPath = node.getRootPath().append(subdirectoryPath);
        return this.create(node.getClientId(), node.getBucket(), fullPath);
    }

    private BlobClientNodeFactory getClientFactories(ClientType<?, ?> clientType) {
        return (BlobClientNodeFactory)this.injector.getInstance(clientType.getClientNodeFactoryClass());
    }
}

