/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.type.index;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.index.IndexEntry;
import io.datarouter.model.index.multi.MultiIndexEntry;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.type.index.MultiIndexNode;
import io.datarouter.storage.op.scan.ManagedIndexIndexToDatabeanScanner;
import io.datarouter.util.tuple.Range;
import java.util.Collection;
import java.util.List;

public class ManualMultiIndexNode<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, IK extends PrimaryKey<IK>, IE extends MultiIndexEntry<IK, IE, PK, D>>
implements MultiIndexNode<PK, D, IK, IE> {
    private MapStorage<PK, D> mainNode;
    private SortedMapStorage<IK, IE> indexNode;

    public ManualMultiIndexNode(MapStorage<PK, D> mainNode, SortedMapStorage<IK, IE> indexNode) {
        this.mainNode = mainNode;
        this.indexNode = indexNode;
    }

    @Override
    public List<D> lookupMulti(IK indexKey, Config config) {
        if (indexKey == null) {
            return List.of();
        }
        Range indexKeyRange = new Range(indexKey, true, indexKey, true);
        return (List)this.indexNode.scan(indexKeyRange, config).map(IndexEntry::getTargetKey).listTo(primaryKeys -> this.mainNode.getMulti((Collection<PK>)primaryKeys, config));
    }

    @Override
    public List<D> lookupMultiMulti(Collection<IK> indexKeys, Config config) {
        if (indexKeys == null || indexKeys.isEmpty()) {
            return List.of();
        }
        return (List)Scanner.of(indexKeys).map(indexKey -> new Range((Comparable)indexKey, true, (Comparable)indexKey, true)).concat(indexKeyRange -> this.indexNode.scan((Range<IK>)indexKeyRange)).map(IndexEntry::getTargetKey).listTo(primaryKeys -> this.mainNode.getMulti((Collection<PK>)primaryKeys, config));
    }

    @Override
    public Scanner<IE> scanRanges(Collection<Range<IK>> ranges, Config config) {
        return this.indexNode.scanRanges(ranges, config);
    }

    @Override
    public Scanner<D> scanDatabeansMulti(Collection<Range<IK>> ranges, Config config) {
        return new ManagedIndexIndexToDatabeanScanner(this.mainNode, this.scanRanges(ranges, config), config);
    }

    @Override
    public Scanner<IK> scanRangesKeys(Collection<Range<IK>> range, Config config) {
        return this.indexNode.scanRangesKeys(range, config);
    }
}

