/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.node.type.indexing.mixin;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.raw.MapStorage;
import io.datarouter.storage.node.op.raw.index.IndexListener;
import java.util.Collection;
import java.util.List;

public interface IndexingMapStorageMixin<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>, N extends MapStorage.MapStorageNode<PK, D, F>>
extends MapStorage<PK, D> {
    public N getBackingNode();

    public List<IndexListener<PK, D>> getIndexNodes();

    @Override
    default public void delete(PK key, Config config) {
        for (IndexListener<PK, D> indexNode : this.getIndexNodes()) {
            indexNode.onDelete(key, config);
        }
        this.getBackingNode().delete(key, config);
    }

    default public void deleteDatabean(D databean) {
        this.deleteDatabean(databean, new Config());
    }

    default public void deleteDatabean(D databean, Config config) {
        for (IndexListener<PK, D> indexNode : this.getIndexNodes()) {
            indexNode.onDeleteDatabean(databean, config);
        }
        this.getBackingNode().delete((PrimaryKey)databean.getKey(), config);
    }

    @Override
    default public void deleteAll(Config config) {
        for (IndexListener<PK, D> indexNode : this.getIndexNodes()) {
            indexNode.onDeleteAll(config);
        }
        this.getBackingNode().deleteAll(config);
    }

    @Override
    default public void deleteMulti(Collection<PK> keys, Config config) {
        for (IndexListener<PK, D> indexNode : this.getIndexNodes()) {
            indexNode.onDeleteMulti(keys, config);
        }
        this.getBackingNode().deleteMulti(keys, config);
    }

    default public void deleteMultiDatabeans(Collection<D> databeans) {
        this.deleteMultiDatabeans(databeans, new Config());
    }

    default public void deleteMultiDatabeans(Collection<D> databeans, Config config) {
        for (IndexListener<PK, D> indexNode : this.getIndexNodes()) {
            indexNode.onDeleteMultiDatabeans(databeans, config);
        }
        Scanner.of(databeans).map(Databean::getKey).flush(keys -> this.getBackingNode().deleteMulti(keys, config));
    }

    @Override
    default public void put(D databean, Config config) {
        for (IndexListener<PK, D> indexNode : this.getIndexNodes()) {
            indexNode.onPut(databean, config);
        }
        this.getBackingNode().put(databean, config);
    }

    @Override
    default public void putMulti(Collection<D> databeans, Config config) {
        for (IndexListener<PK, D> indexNode : this.getIndexNodes()) {
            indexNode.onPutMulti(databeans, config);
        }
        this.getBackingNode().putMulti(databeans, config);
    }

    @Override
    default public boolean exists(PK key, Config config) {
        return this.getBackingNode().exists(key, config);
    }

    @Override
    default public D get(PK key, Config config) {
        return this.getBackingNode().get(key, config);
    }

    @Override
    default public List<D> getMulti(Collection<PK> keys, Config config) {
        return this.getBackingNode().getMulti(keys, config);
    }

    @Override
    default public List<PK> getKeys(Collection<PK> keys, Config config) {
        return this.getBackingNode().getKeys(keys, config);
    }
}

