/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.op.scan.queue;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.BaseScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.node.op.raw.QueueStorage;
import io.datarouter.storage.queue.QueueMessage;

public class PollUntilEmptyQueueStorageScanner<PK extends PrimaryKey<PK>, D extends Databean<PK, D>>
extends BaseScanner<D> {
    private final QueueStorage<PK, D> queueStorage;
    private final Scanner<QueueMessage<PK, D>> queueMessageScanner;

    public PollUntilEmptyQueueStorageScanner(QueueStorage<PK, D> queueStorage, Config config) {
        this.queueStorage = queueStorage;
        this.queueMessageScanner = queueStorage.peekUntilEmpty(config);
    }

    public boolean advance() {
        if (this.queueMessageScanner.advance()) {
            QueueMessage message = (QueueMessage)this.queueMessageScanner.current();
            this.queueStorage.ack(message.getKey());
            this.current = message.getDatabean();
            return true;
        }
        return false;
    }
}

