/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.serialize.fieldcache;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.DatabeanFielder;
import io.datarouter.util.lang.ReflectionTool;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class IndexEntryFieldInfo<PK extends PrimaryKey<PK>, D extends Databean<PK, D>, F extends DatabeanFielder<PK, D>> {
    private final String indexName;
    private final Supplier<D> databeanSupplier;
    private final Supplier<F> fielderSupplier;
    private final D sampleDatabean;
    private final F sampleFielder;
    private final Class<PK> primaryKeyClass;
    private final List<Field<?>> fields;
    private final List<Field<?>> primaryKeyFields;
    private final List<String> primaryKeyFieldColumnNames;
    private final List<String> fieldColumnNames;

    public IndexEntryFieldInfo(String indexName, Supplier<D> databeanSupplier, Supplier<F> fielderSupplier) {
        this.indexName = indexName;
        this.databeanSupplier = databeanSupplier;
        this.fielderSupplier = fielderSupplier;
        this.sampleDatabean = (Databean)databeanSupplier.get();
        this.sampleFielder = (DatabeanFielder)fielderSupplier.get();
        this.primaryKeyClass = this.sampleDatabean.getKeyClass();
        this.fields = this.sampleFielder.getFields(this.sampleDatabean);
        this.primaryKeyFields = ((PrimaryKey)ReflectionTool.create(this.primaryKeyClass)).getFields();
        this.primaryKeyFieldColumnNames = this.createFieldColumnNames(this.primaryKeyFields);
        this.fieldColumnNames = this.createFieldColumnNames(this.fields);
    }

    private List<String> createFieldColumnNames(List<Field<?>> fields) {
        return fields.stream().map(Field::getKey).map(FieldKey::getColumnName).collect(Collectors.toList());
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Supplier<D> getDatabeanSupplier() {
        return this.databeanSupplier;
    }

    public Supplier<F> getFielderSupplier() {
        return this.fielderSupplier;
    }

    public D getSampleDatabean() {
        return this.sampleDatabean;
    }

    public F getSampleFielder() {
        return this.sampleFielder;
    }

    public Class<PK> getPrimaryKeyClass() {
        return this.primaryKeyClass;
    }

    public List<Field<?>> getFields() {
        return this.fields;
    }

    public List<Field<?>> getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public List<String> getPrimaryKeyFieldColumnNames() {
        return this.primaryKeyFieldColumnNames;
    }

    public List<String> getFieldColumnNames() {
        return this.fieldColumnNames;
    }
}

