/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.setting;

import io.datarouter.storage.config.environment.DatarouterEnvironmentType;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.setting.DatarouterSettingTag;
import io.datarouter.storage.setting.DefaultSettingValueWinner;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class DefaultSettingValue<T> {
    private T globalDefault;
    private final Map<DatarouterEnvironmentType, T> valueByEnvironmentType;
    private final Map<DatarouterEnvironmentType, Map<String, T>> valueByServerTypeByEnvironmentType;
    private final Map<DatarouterEnvironmentType, Map<String, T>> valueByServerNameByEnvironmentType;
    private final Map<DatarouterEnvironmentType, Map<String, T>> valueByEnvironmentNameByEnvironmentType;
    private final Map<DatarouterSettingTag, Supplier<T>> valueBySettingTag;
    private DefaultSettingValueWinner defaultSettingValueWinner;

    public DefaultSettingValue(T globalDefault) {
        this.globalDefault = globalDefault;
        this.valueByEnvironmentType = new HashMap<DatarouterEnvironmentType, T>();
        this.valueByServerTypeByEnvironmentType = new HashMap<DatarouterEnvironmentType, Map<String, T>>();
        this.valueByServerNameByEnvironmentType = new HashMap<DatarouterEnvironmentType, Map<String, T>>();
        this.valueByEnvironmentNameByEnvironmentType = new HashMap<DatarouterEnvironmentType, Map<String, T>>();
        this.valueBySettingTag = new HashMap<DatarouterSettingTag, Supplier<T>>();
        this.defaultSettingValueWinner = DefaultSettingValueWinner.globalDefault();
    }

    public DefaultSettingValue<T> withEnvironmentType(Supplier<DatarouterEnvironmentType> environmentTypeSupplier, T value) {
        this.valueByEnvironmentType.put(environmentTypeSupplier.get(), value);
        return this;
    }

    public DefaultSettingValue<T> withEnvironmentName(Supplier<DatarouterEnvironmentType> environmentTypeSupplier, String environment, T value) {
        this.valueByEnvironmentNameByEnvironmentType.computeIfAbsent(environmentTypeSupplier.get(), $ -> new HashMap()).put(environment, value);
        return this;
    }

    public DefaultSettingValue<T> withServerType(Supplier<DatarouterEnvironmentType> environmentTypeSupplier, ServerType serverType, T value) {
        this.valueByServerTypeByEnvironmentType.computeIfAbsent(environmentTypeSupplier.get(), $ -> new HashMap()).put(serverType.getPersistentString(), value);
        return this;
    }

    public DefaultSettingValue<T> withServerName(Supplier<DatarouterEnvironmentType> environmentTypeSupplier, String serverName, T value) {
        this.valueByServerNameByEnvironmentType.computeIfAbsent(environmentTypeSupplier.get(), $ -> new HashMap()).put(serverName, value);
        return this;
    }

    public DefaultSettingValue<T> withTag(Supplier<DatarouterSettingTag> tagTypeSupplier, Supplier<T> value) {
        this.valueBySettingTag.put(tagTypeSupplier.get(), value);
        return this;
    }

    public DefaultSettingValue<T> setGlobalDefault(T value) {
        this.globalDefault = value;
        return this;
    }

    public Map<DatarouterEnvironmentType, Map<String, T>> getValueByServerTypeByEnvironmentType() {
        return this.valueByServerTypeByEnvironmentType;
    }

    public Map<DatarouterEnvironmentType, Map<String, T>> getValueByServerNameByEnvironmentType() {
        return this.valueByServerNameByEnvironmentType;
    }

    public Map<DatarouterEnvironmentType, Map<String, T>> getValueByEnvironmentNameByEnvironmentType() {
        return this.valueByEnvironmentNameByEnvironmentType;
    }

    public Map<DatarouterEnvironmentType, T> getValueByEnvironmentType() {
        return this.valueByEnvironmentType;
    }

    public Map<DatarouterSettingTag, Supplier<T>> getValueBySettingTag() {
        return this.valueBySettingTag;
    }

    public Map<String, T> getValueByServerName(DatarouterEnvironmentType environmentType) {
        return this.valueByServerNameByEnvironmentType.getOrDefault(environmentType, new HashMap());
    }

    public Map<String, T> getValueByServerType(DatarouterEnvironmentType environmentType) {
        return this.valueByServerTypeByEnvironmentType.getOrDefault(environmentType, new HashMap());
    }

    public Map<String, T> getValueByEnvironmentName(DatarouterEnvironmentType environmentType) {
        return this.valueByEnvironmentNameByEnvironmentType.getOrDefault(environmentType, new HashMap());
    }

    public T getGlobalDefault() {
        return this.globalDefault;
    }

    public T getValue(String environmentTypeString, String environmentName, ServerType serverType, String serverName, List<DatarouterSettingTag> settingTags) {
        return this.getValue(new DatarouterEnvironmentType(environmentTypeString), environmentName, serverType, serverName, settingTags);
    }

    public T getValue(DatarouterEnvironmentType environmentType, String environmentName, ServerType serverType, String serverName, List<DatarouterSettingTag> settingTags) {
        String serverTypeString = serverType == null ? null : serverType.getPersistentString();
        return this.getValue(environmentType, environmentName, serverTypeString, serverName, settingTags);
    }

    public T getValue(DatarouterEnvironmentType environmentType, String environmentName, String serverTypeString, String serverName, List<DatarouterSettingTag> settingTags) {
        T value;
        T value2;
        T value3;
        Map<String, T> valueByServerName = this.getValueByServerName(environmentType);
        if (!valueByServerName.isEmpty() && (value3 = valueByServerName.get(serverName)) != null) {
            this.defaultSettingValueWinner = new DefaultSettingValueWinner(DefaultSettingValueWinner.DefaultSettingValueWinnerType.SERVER_NAME, environmentType.getPersistentString(), environmentName, serverTypeString, serverName, String.valueOf(value3));
            return value3;
        }
        Map<String, T> valueByServerType = this.getValueByServerType(environmentType);
        if (!valueByServerType.isEmpty() && (value2 = valueByServerType.get(serverTypeString)) != null) {
            this.defaultSettingValueWinner = new DefaultSettingValueWinner(DefaultSettingValueWinner.DefaultSettingValueWinnerType.SERVER_TYPE, environmentType.getPersistentString(), environmentName, serverTypeString, serverName, String.valueOf(value2));
            return value2;
        }
        Map<String, T> valueByEnvironmentName = this.getValueByEnvironmentName(environmentType);
        if (!valueByEnvironmentName.isEmpty() && (value = valueByEnvironmentName.get(environmentName)) != null) {
            this.defaultSettingValueWinner = new DefaultSettingValueWinner(DefaultSettingValueWinner.DefaultSettingValueWinnerType.ENVIRONMENT_NAME, environmentType.getPersistentString(), environmentName, serverTypeString, serverName, String.valueOf(value));
            return value;
        }
        T valueForEnvironmentType = this.valueByEnvironmentType.get(environmentType);
        if (valueForEnvironmentType != null) {
            this.defaultSettingValueWinner = new DefaultSettingValueWinner(DefaultSettingValueWinner.DefaultSettingValueWinnerType.ENVIRONMENT_TYPE, environmentType.getPersistentString(), environmentName, serverTypeString, serverName, String.valueOf(valueForEnvironmentType));
            return valueForEnvironmentType;
        }
        Optional<DatarouterSettingTag> matchedTag = settingTags.stream().filter(this.valueBySettingTag::containsKey).findFirst();
        if (matchedTag.isPresent()) {
            T value4 = this.valueBySettingTag.get(matchedTag.get()).get();
            this.defaultSettingValueWinner = DefaultSettingValueWinner.settingTag(matchedTag.get().getPersistentString(), String.valueOf(value4));
            return value4;
        }
        this.defaultSettingValueWinner = DefaultSettingValueWinner.globalDefault();
        return this.globalDefault;
    }

    public DefaultSettingValueWinner getDefaultSettingValueWinner() {
        return this.defaultSettingValueWinner;
    }
}

