/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.setting;

import io.datarouter.scanner.OptionalScanner;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.storage.setting.DatarouterSettingTag;
import io.datarouter.storage.setting.SettingFinder;
import io.datarouter.storage.setting.cached.CachedSetting;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class MemorySettingFinder
implements SettingFinder {
    private final String environmentType;
    private final String environment;
    private final ServerType serverType;
    private final String serverName;
    private final List<DatarouterSettingTag> settingTags;
    protected final Map<String, Object> settings;

    public MemorySettingFinder() {
        this(null, null, null, null, List.of());
    }

    public MemorySettingFinder(String environmentType, String environment, ServerType serverType, String serverName, List<DatarouterSettingTag> settingTags) {
        this.environmentType = environmentType;
        this.environment = environment;
        this.serverType = serverType;
        this.serverName = serverName;
        this.settingTags = settingTags;
        this.settings = new ConcurrentHashMap<String, Object>();
    }

    @Override
    public String getEnvironmentType() {
        return this.environmentType;
    }

    @Override
    public String getEnvironmentName() {
        return this.environment;
    }

    @Override
    public ServerType getServerType() {
        return this.serverType;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public List<DatarouterSettingTag> getSettingTags() {
        return this.settingTags;
    }

    @Override
    public Optional<String> getSettingValue(String name) {
        Object value = this.settings.get(name);
        return Optional.ofNullable(value).map(Object::toString);
    }

    @Override
    public List<String> getAllCustomSettingValues(String name) {
        return OptionalScanner.of(this.getSettingValue(name)).list();
    }

    public void setSettingValue(String name, Object value) {
        this.settings.put(name, value);
    }

    public void clear() {
        this.settings.clear();
    }

    @Override
    public void registerCachedSetting(CachedSetting<?> setting) {
    }

    @Override
    public void validateAllCachedSettings() {
    }
}

