/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.sql;

import io.datarouter.model.field.Field;
import io.datarouter.model.field.FieldSet;
import io.datarouter.model.field.FieldTool;
import io.datarouter.storage.config.Config;
import io.datarouter.util.tuple.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Sql<C, P, Q extends Sql<C, P, Q>> {
    private static final Logger logger = LoggerFactory.getLogger(Sql.class);
    protected final Q implementation;
    protected final StringBuilder sqlBuilder;
    protected final ArrayList<BiConsumer<P, Integer>> parameterSetters;

    protected Sql(Class<Q> subclass) {
        this.implementation = (Sql)subclass.cast(this);
        this.sqlBuilder = new StringBuilder();
        this.parameterSetters = new ArrayList();
    }

    public abstract Q addLimitOffsetClause(Config var1);

    public abstract Q addSqlNameValueWithOperator(Field<?> var1, String var2, boolean var3);

    public abstract Q appendColumnEqualsValueParameter(Field<?> var1);

    public abstract P prepare(C var1);

    public Q appendSqlNameValue(Field<?> field, boolean rejectNulls) {
        return this.addSqlNameValueWithOperator(field, "=", rejectNulls);
    }

    public Q append(String value) {
        this.sqlBuilder.append(value);
        return this.implementation;
    }

    public Q appendParameter(String value, BiConsumer<P, Integer> parameterSetter) {
        this.sqlBuilder.append(value);
        this.parameterSetters.add(parameterSetter);
        return this.implementation;
    }

    public Q insert(String tableName, List<List<Field<?>>> databeans, boolean ignore) {
        this.append("insert");
        if (ignore) {
            this.append(" ignore");
        }
        this.append(" into ");
        this.append(tableName);
        this.append(" (");
        Sql.appendCsvColumnNames(this.sqlBuilder, databeans.get(0));
        this.append(") values ");
        boolean didOneDatabean = false;
        for (List<Field<?>> databeanFields : databeans) {
            if (didOneDatabean) {
                this.append(", ");
            }
            this.append("(");
            boolean didOneField = false;
            for (Field<?> field : databeanFields) {
                if (didOneField) {
                    this.append(", ");
                }
                this.appendColumnEqualsValueParameter(field);
                didOneField = true;
            }
            this.append(")");
            didOneDatabean = true;
        }
        return this.implementation;
    }

    public Q update(String tableName, List<Field<?>> fieldsToUpdate, List<? extends FieldSet<?>> keys) {
        this.addUpdateClause(tableName);
        boolean didOne = false;
        for (Field<?> field : fieldsToUpdate) {
            if (didOne) {
                this.append(", ");
            }
            this.appendSqlNameValue(field, false);
            didOne = true;
        }
        this.appendWhereClauseDisjunction(keys);
        return this.implementation;
    }

    public Q deleteMulti(String tableName, Config config, Collection<? extends FieldSet<?>> keys) {
        this.addDeleteFromClause(tableName);
        this.appendWhereClauseDisjunction(keys);
        this.addLimitOffsetClause(config);
        return this.implementation;
    }

    public Q getMulti(String tableName, Config config, List<Field<?>> selectFields, Collection<? extends FieldSet<?>> keys, String indexName) {
        this.addSelectFromClause(tableName, selectFields);
        this.addForceIndexClause(indexName);
        this.appendWhereClauseDisjunction(keys);
        this.addLimitOffsetClause(config);
        return this.implementation;
    }

    public Q getWithPrefixes(String tableName, Config config, String indexName, List<Field<?>> selectFields, Collection<? extends FieldSet<?>> keys, List<Field<?>> orderByFields) {
        this.addSelectFromClause(tableName, selectFields);
        this.addForceIndexClause(indexName);
        this.appendPrefixWhereClauseDisjunction(keys);
        this.addOrderByClause(orderByFields);
        this.addLimitOffsetClause(config);
        return this.implementation;
    }

    public <T extends FieldSet<T>> Q getInRanges(String tableName, Config config, List<Field<?>> selectFields, Iterable<Range<T>> ranges, List<Field<?>> orderByFields, String indexName) {
        this.addSelectFromClause(tableName, selectFields);
        this.addForceIndexClause(indexName);
        boolean hasWhereClause = false;
        for (Range<T> range : ranges) {
            if (!Sql.needsRangeWhereClause((FieldSet)range.getStart(), (FieldSet)range.getEnd())) continue;
            if (hasWhereClause) {
                this.append(" or ");
            } else {
                this.append(" where ");
                hasWhereClause = true;
            }
            this.addRangeWhereClause(range);
        }
        this.addOrderByClause(orderByFields);
        this.addLimitOffsetClause(config);
        return this.implementation;
    }

    public Q appendWhereClauseDisjunction(Collection<? extends FieldSet<?>> fieldSets) {
        if (fieldSets == null || fieldSets.isEmpty()) {
            return this.implementation;
        }
        this.append(" where ");
        boolean didOne = false;
        for (FieldSet<?> fieldSet : fieldSets) {
            if (didOne) {
                this.append(" or ");
            }
            this.getSqlNameValuePairsEscapedConjunction(fieldSet.getFields());
            didOne = true;
        }
        return this.implementation;
    }

    private boolean addPrefixWhereClause(FieldSet<?> prefix, boolean shouldAppendWhere) {
        int numNonNullFields = FieldTool.countNonNullLeadingFields((List)prefix.getFields());
        if (numNonNullFields == 0) {
            return true;
        }
        int numFullFieldsFinished = 0;
        for (Field field : prefix.getFields()) {
            if (numFullFieldsFinished >= numNonNullFields) break;
            if (numFullFieldsFinished > 0) {
                this.append(" and ");
            } else if (shouldAppendWhere) {
                this.append(" where ");
                shouldAppendWhere = false;
            }
            this.appendSqlNameValue(field, true);
            ++numFullFieldsFinished;
        }
        return shouldAppendWhere;
    }

    private Q appendPrefixWhereClauseDisjunction(Collection<? extends FieldSet<?>> keys) {
        boolean didOne = false;
        boolean shouldAppendWhere = true;
        for (FieldSet<?> key : keys) {
            if (didOne) {
                this.append(" or ");
            }
            shouldAppendWhere = this.addPrefixWhereClause(key, shouldAppendWhere);
            didOne = true;
        }
        return this.implementation;
    }

    private void getSqlNameValuePairsEscapedConjunction(Collection<Field<?>> fields) {
        boolean didOne = false;
        for (Field<?> field : fields) {
            if (didOne) {
                this.append(" and ");
            }
            this.appendSqlNameValue(field, true);
            didOne = true;
        }
    }

    private Q addRangeWhereClause(Range<? extends FieldSet<?>> range) {
        String operator;
        int j;
        int i;
        if (range.isEmpty()) {
            this.append("0");
            logger.warn("range should probably not be empty at this point {} {}", new Object[]{range, this.sqlBuilder, new Exception()});
            return this.implementation;
        }
        boolean hasStart = false;
        List startFields = null;
        int numNonNullStartFields = 0;
        if (range.getStart() != null) {
            startFields = ((FieldSet)range.getStart()).getFields();
            numNonNullStartFields = FieldTool.countNonNullLeadingFields((List)startFields);
        }
        List endFields = null;
        int numNonNullEndFields = 0;
        if (range.getEnd() != null) {
            endFields = ((FieldSet)range.getEnd()).getFields();
            numNonNullEndFields = FieldTool.countNonNullLeadingFields((List)endFields);
        }
        int numEqualsLeadingFields = 0;
        if (range.getStart() != null && range.getEnd() != null) {
            int numNonNullLeadingFields = Math.min(numNonNullStartFields, numNonNullEndFields);
            int i2 = 0;
            while (i2 < numNonNullLeadingFields) {
                if (!((Field)startFields.get(i2)).getValue().equals(((Field)endFields.get(i2)).getValue())) break;
                if (i2 > 0) {
                    this.append(" and ");
                } else {
                    this.append("(");
                }
                this.appendSqlNameValue((Field)startFields.get(i2), true);
                ++numEqualsLeadingFields;
                ++i2;
            }
        }
        if (range.getStart() != null && numNonNullStartFields > 0 && numNonNullStartFields > numEqualsLeadingFields) {
            hasStart = true;
            if (numEqualsLeadingFields > 0) {
                this.append(" and ");
            }
            this.append("(");
            i = numNonNullStartFields;
            while (i > numEqualsLeadingFields) {
                if (i < numNonNullStartFields) {
                    this.append(" or ");
                }
                this.append("(");
                j = numEqualsLeadingFields;
                while (j < i) {
                    if (j > numEqualsLeadingFields) {
                        this.append(" and ");
                    }
                    Field startField = (Field)startFields.get(j);
                    operator = j < i - 1 ? "=" : (range.getStartInclusive() && i == numNonNullStartFields ? ">=" : ">");
                    this.addSqlNameValueWithOperator(startField, operator, true);
                    ++j;
                }
                this.append(")");
                --i;
            }
            this.append(")");
        }
        if (range.getEnd() != null && numNonNullEndFields > 0 && numNonNullEndFields > numEqualsLeadingFields) {
            if (numEqualsLeadingFields > 0 || hasStart) {
                this.append(" and ");
            }
            this.append("(");
            i = numEqualsLeadingFields;
            while (i < numNonNullEndFields) {
                if (i > numEqualsLeadingFields) {
                    this.append(" or ");
                }
                this.append("(");
                j = numEqualsLeadingFields;
                while (j <= i) {
                    if (j > numEqualsLeadingFields) {
                        this.append(" and ");
                    }
                    Field endField = (Field)endFields.get(j);
                    operator = j != i ? "=" : (range.getEndInclusive() && i == numNonNullEndFields - 1 ? "<=" : "<");
                    this.addSqlNameValueWithOperator(endField, operator, true);
                    ++j;
                }
                this.append(")");
                ++i;
            }
            this.append(")");
        }
        if (numEqualsLeadingFields > 0) {
            this.append(")");
        }
        return this.implementation;
    }

    public Q deleteAll(Config config, String tableName) {
        this.addDeleteFromClause(tableName);
        this.addLimitOffsetClause(config);
        return this.implementation;
    }

    public Q addForceIndexClause(String indexName) {
        if (indexName == null) {
            return this.implementation;
        }
        this.append(" force index (");
        this.append(indexName);
        this.append(")");
        return this.implementation;
    }

    public Q addSelectFromClause(String tableName, List<Field<?>> selectFields) {
        this.append("select ");
        Sql.appendCsvColumnNames(this.sqlBuilder, selectFields);
        this.append(" from " + tableName);
        return this.implementation;
    }

    public Q addDeleteFromClause(String tableName) {
        this.append("delete from " + tableName);
        return this.implementation;
    }

    public Q addUpdateClause(String tableName) {
        this.append("update ");
        this.append(tableName);
        this.append(" set ");
        return this.implementation;
    }

    public static boolean needsRangeWhereClause(FieldSet<?> start, FieldSet<?> end) {
        return start != null && FieldTool.countNonNullLeadingFields((List)start.getFields()) > 0 || end != null && FieldTool.countNonNullLeadingFields((List)end.getFields()) > 0;
    }

    public Q addOrderByClause(List<Field<?>> orderByFields) {
        if (orderByFields == null || orderByFields.isEmpty()) {
            return this.implementation;
        }
        this.append(" order by ");
        int counter = 0;
        for (Field<?> field : orderByFields) {
            if (counter > 0) {
                this.append(", ");
            }
            this.append(String.valueOf(field.getKey().getColumnName()) + " asc");
            ++counter;
        }
        return this.implementation;
    }

    public String toString() {
        return this.sqlBuilder.toString();
    }

    private static void appendCsvColumnNames(StringBuilder sb, List<Field<?>> fields) {
        int appended = 0;
        for (Field<?> field : fields) {
            if (appended > 0) {
                sb.append(", ");
            }
            sb.append(field.getKey().getColumnName());
            ++appended;
        }
    }
}

