/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.storage.util;

import io.datarouter.util.bytes.ByteTool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;

public class MultiByteArrayInputStream
extends InputStream {
    private final Iterator<byte[]> iter;
    private byte[] current;
    private int position;

    public MultiByteArrayInputStream(Iterable<byte[]> arrays) {
        this(arrays.iterator());
    }

    public MultiByteArrayInputStream(Iterator<byte[]> arrays) {
        this.iter = arrays;
        this.current = ByteTool.EMPTY_ARRAY;
        this.position = 0;
    }

    @Override
    public int read() {
        while (this.remainingInCurrent() == 0 && this.advance()) {
        }
        if (this.remainingInCurrent() == 0) {
            return -1;
        }
        byte value = this.current[this.position];
        ++this.position;
        return Byte.toUnsignedInt(value);
    }

    @Override
    public int read(byte[] destination, int off, int len) {
        if (len == 0) {
            return 0;
        }
        int count = 0;
        while (count < len) {
            int numCurrent = this.remainingInCurrent();
            if (numCurrent > 0) {
                int numPending = len - count;
                int copySize = Math.min(numPending, numCurrent);
                System.arraycopy(this.current, this.position, destination, count, copySize);
                this.position += copySize;
                count += copySize;
            }
            if (count == len || !this.advance()) break;
        }
        return count == 0 ? -1 : count;
    }

    @Override
    public byte[] readAllBytes() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.write(this.current, this.position, this.remainingInCurrent());
        while (this.advance()) {
            buffer.write(this.current, this.position, this.remainingInCurrent());
        }
        this.current = ByteTool.EMPTY_ARRAY;
        this.position = 0;
        return buffer.toByteArray();
    }

    @Override
    public byte[] readNBytes(int len) {
        byte[] buffer = new byte[len];
        int numRead = this.readNBytes(buffer, 0, len);
        return numRead == len ? buffer : Arrays.copyOf(buffer, numRead);
    }

    @Override
    public int readNBytes(byte[] buffer, int off, int len) {
        int numBytesRead = this.read(buffer, off, len);
        return numBytesRead == -1 ? 0 : numBytesRead;
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        long count = 0L;
        count += (long)this.remainingInCurrent();
        out.write(this.current, this.position, this.remainingInCurrent());
        while (this.advance()) {
            count += (long)this.remainingInCurrent();
            out.write(this.current, this.position, this.remainingInCurrent());
        }
        this.current = ByteTool.EMPTY_ARRAY;
        this.position = 0;
        return count;
    }

    private int remainingInCurrent() {
        return this.current.length - this.position;
    }

    private boolean advance() {
        this.position = 0;
        if (this.iter.hasNext()) {
            this.current = this.iter.next();
            return true;
        }
        this.current = ByteTool.EMPTY_ARRAY;
        return false;
    }
}

