/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.config;

import io.datarouter.instrumentation.trace.TracePublisher;
import io.datarouter.job.config.BaseJobPlugin;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaosModuleBuilder;
import io.datarouter.trace.config.DatarouterLocalTraceTriggerGroup;
import io.datarouter.trace.config.DatarouterTracePaths;
import io.datarouter.trace.config.DatarouterTraceRouteSet;
import io.datarouter.trace.conveyor.local.FilterToMemoryBufferForLocal;
import io.datarouter.trace.conveyor.local.LocalTraceConveyors;
import io.datarouter.trace.conveyor.local.Trace2ForLocalHttpRequestRecordQueueDao;
import io.datarouter.trace.conveyor.local.Trace2ForLocalQueueDao;
import io.datarouter.trace.conveyor.local.TraceLocalFilterToMemoryBuffer;
import io.datarouter.trace.conveyor.local.TraceQueueLocalDao;
import io.datarouter.trace.conveyor.publisher.FilterToMemoryBufferForPublisher;
import io.datarouter.trace.conveyor.publisher.Trace2ForPublisherHttpRequestRecordQueueDao;
import io.datarouter.trace.conveyor.publisher.Trace2ForPublisherQueueDao;
import io.datarouter.trace.conveyor.publisher.TracePublisherConveyors;
import io.datarouter.trace.conveyor.publisher.TracePublisherFilterToMemoryBuffer;
import io.datarouter.trace.conveyor.publisher.TraceQueuePublisherDao;
import io.datarouter.trace.filter.GuiceTraceFilter;
import io.datarouter.trace.service.TraceUrlBuilder;
import io.datarouter.trace.settings.DatarouterTraceFilterSettingRoot;
import io.datarouter.trace.settings.DatarouterTraceLocalSettingRoot;
import io.datarouter.trace.settings.DatarouterTracePublisherSettingRoot;
import io.datarouter.trace.storage.BaseDatarouterTraceDao;
import io.datarouter.trace.storage.DatarouterTraceDao;
import io.datarouter.trace.storage.Trace2ForLocalDao;
import io.datarouter.web.dispatcher.FilterParams;
import io.datarouter.web.navigation.DatarouterNavBarCategory;
import io.datarouter.web.navigation.NavBarCategory;
import java.util.ArrayList;
import java.util.List;

public class DatarouterTracePlugin
extends BaseJobPlugin {
    private final Class<? extends TracePublisher> tracePublisher;
    private final Class<? extends TraceUrlBuilder> traceUrlBuilder;
    private final boolean enableLocalTraces;
    private final boolean enablePublisherTraces;

    private DatarouterTracePlugin(boolean enableLocalTraces, boolean enablePublisherTraces, DatarouterTraceDaoModule daosModule, Class<? extends TracePublisher> tracePublisher, boolean addLocalVacuumJobs, Class<? extends TraceUrlBuilder> traceUrlBuilder) {
        this.tracePublisher = tracePublisher;
        this.enableLocalTraces = enableLocalTraces;
        this.enablePublisherTraces = enablePublisherTraces;
        this.traceUrlBuilder = traceUrlBuilder;
        this.addSettingRoot(DatarouterTraceFilterSettingRoot.class);
        if (enableLocalTraces) {
            this.addAppListener(LocalTraceConveyors.class);
            this.addRouteSet(DatarouterTraceRouteSet.class);
            this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.MONITORING, new DatarouterTracePaths().datarouter.traces, "Traces");
            this.addSettingRoot(DatarouterTraceLocalSettingRoot.class);
            if (addLocalVacuumJobs) {
                this.addTriggerGroup(DatarouterLocalTraceTriggerGroup.class);
            }
        }
        if (enablePublisherTraces) {
            this.addAppListener(TracePublisherConveyors.class);
            this.addSettingRoot(DatarouterTracePublisherSettingRoot.class);
        }
        this.addFilterParams(new FilterParams(false, "/*", GuiceTraceFilter.class));
        this.setDaosModule(daosModule);
        this.addDatarouterGithubDocLink("datarouter-trace");
    }

    public String getName() {
        return "DatarouterTrace";
    }

    public void configure() {
        if (this.enableLocalTraces) {
            this.bind(FilterToMemoryBufferForLocal.class).to(TraceLocalFilterToMemoryBuffer.class);
            this.bindActual(BaseDatarouterTraceDao.class, DatarouterTraceDao.class);
        } else {
            this.bind(FilterToMemoryBufferForLocal.class).to(FilterToMemoryBufferForLocal.NoOpFilterToMemoryBufferForLocal.class);
            this.bindActual(BaseDatarouterTraceDao.class, BaseDatarouterTraceDao.NoOpDatarouterTraceDao.class);
        }
        if (this.enablePublisherTraces) {
            this.bind(FilterToMemoryBufferForPublisher.class).to(TracePublisherFilterToMemoryBuffer.class);
            this.bind(TracePublisher.class).to(this.tracePublisher);
        } else {
            this.bind(FilterToMemoryBufferForPublisher.class).to(FilterToMemoryBufferForPublisher.NoOpFilterToMemoryBufferForPublisher.class);
            this.bind(TracePublisher.class).to(TracePublisher.NoOpTracePublisher.class);
        }
        this.bind(TraceUrlBuilder.class).to(this.traceUrlBuilder);
    }

    public static class DatarouterTraceDaoModule
    extends DaosModuleBuilder {
        private final boolean enableLocalTraces;
        private final boolean enableTracePublisher;
        private final ClientId localTraceClientId;
        private final ClientId localTraceQueueClientId;
        private final ClientId publishingTraceQueueClientId;

        public DatarouterTraceDaoModule(boolean enableTraceLocal, boolean enableTracePublisher, ClientId localTraceClientId, ClientId localTraceQueueClientId, ClientId publishingTraceQueueClientId) {
            this.enableLocalTraces = enableTraceLocal;
            this.enableTracePublisher = enableTracePublisher;
            this.localTraceClientId = localTraceClientId;
            this.localTraceQueueClientId = localTraceQueueClientId;
            this.publishingTraceQueueClientId = publishingTraceQueueClientId;
        }

        public List<Class<? extends Dao>> getDaoClasses() {
            ArrayList<Class<? extends Dao>> daos = new ArrayList<Class<? extends Dao>>();
            if (this.enableLocalTraces) {
                daos.add(DatarouterTraceDao.class);
                daos.add(TraceQueueLocalDao.class);
                daos.add(Trace2ForLocalQueueDao.class);
                daos.add(Trace2ForLocalDao.class);
                daos.add(Trace2ForLocalHttpRequestRecordQueueDao.class);
            }
            if (this.enableTracePublisher) {
                daos.add(TraceQueuePublisherDao.class);
                daos.add(Trace2ForPublisherQueueDao.class);
                daos.add(Trace2ForPublisherHttpRequestRecordQueueDao.class);
            }
            return daos;
        }

        public void configure() {
            if (this.enableLocalTraces) {
                this.bind(DatarouterTraceDao.DatarouterTraceDaoParams.class).toInstance((Object)new DatarouterTraceDao.DatarouterTraceDaoParams(this.localTraceClientId));
                this.bind(TraceQueueLocalDao.TraceQueueLocalDaoParams.class).toInstance((Object)new TraceQueueLocalDao.TraceQueueLocalDaoParams(this.localTraceQueueClientId));
                this.bind(Trace2ForLocalDao.Trace2ForLocalDaoParams.class).toInstance((Object)new Trace2ForLocalDao.Trace2ForLocalDaoParams(this.localTraceClientId));
                this.bind(Trace2ForLocalQueueDao.Trace2ForLocalQueueDaoParams.class).toInstance((Object)new Trace2ForLocalQueueDao.Trace2ForLocalQueueDaoParams(this.localTraceQueueClientId));
                this.bind(Trace2ForLocalHttpRequestRecordQueueDao.Trace2ForLocalHttpRequestRecordQueueDaoParams.class).toInstance((Object)new Trace2ForLocalHttpRequestRecordQueueDao.Trace2ForLocalHttpRequestRecordQueueDaoParams(this.localTraceQueueClientId));
            }
            if (this.enableTracePublisher) {
                this.bind(TraceQueuePublisherDao.TraceQueuePublisherDaoParams.class).toInstance((Object)new TraceQueuePublisherDao.TraceQueuePublisherDaoParams(this.publishingTraceQueueClientId));
                this.bind(Trace2ForPublisherQueueDao.Trace2ForPublisherQueueDaoParams.class).toInstance((Object)new Trace2ForPublisherQueueDao.Trace2ForPublisherQueueDaoParams(this.publishingTraceQueueClientId));
                this.bind(Trace2ForPublisherHttpRequestRecordQueueDao.Trace2ForPublisherHttpRequestRecordQueueDaoParams.class).toInstance((Object)new Trace2ForPublisherHttpRequestRecordQueueDao.Trace2ForPublisherHttpRequestRecordQueueDaoParams(this.publishingTraceQueueClientId));
            }
        }
    }

    public static class DatarouterTracePluginBuilder {
        private boolean enableTraceLocal = false;
        private boolean enableTracePublisher = false;
        private DatarouterTraceDaoModule daoModule;
        private ClientId localTraceClientId;
        private ClientId localTraceQueueClientId;
        private ClientId publishingTraceQueueClientId;
        private Class<? extends TracePublisher> tracePublisher;
        private boolean addLocalVacuumJobs = false;
        private Class<? extends TraceUrlBuilder> traceUrlBuilder = TraceUrlBuilder.LocalTraceUrlBulder.class;

        public DatarouterTracePluginBuilder enableTraceLocal(ClientId localTraceClientId, ClientId localTraceQueueClientId, boolean addLocalVacuumJobs) {
            this.enableTraceLocal = true;
            this.localTraceClientId = localTraceClientId;
            this.localTraceQueueClientId = localTraceQueueClientId;
            this.addLocalVacuumJobs = addLocalVacuumJobs;
            return this;
        }

        public DatarouterTracePluginBuilder enableTracePublishing(ClientId publishingTraceQueueClientId, Class<? extends TracePublisher> tracePublisher) {
            this.enableTracePublisher = true;
            this.publishingTraceQueueClientId = publishingTraceQueueClientId;
            this.tracePublisher = tracePublisher;
            return this;
        }

        public DatarouterTracePluginBuilder setDaosModule(boolean enableLocalTraces, boolean enableTracePublisher, ClientId localTraceClientId, ClientId localTraceQueueClientId, ClientId publishingTraceQueueClientId) {
            this.daoModule = new DatarouterTraceDaoModule(enableLocalTraces, enableTracePublisher, localTraceClientId, localTraceQueueClientId, publishingTraceQueueClientId);
            return this;
        }

        public DatarouterTracePluginBuilder setTraceUrlBuilder(Class<? extends TraceUrlBuilder> traceUrlBuilder) {
            this.traceUrlBuilder = traceUrlBuilder;
            return this;
        }

        public DatarouterTracePlugin build() {
            DatarouterTraceDaoModule module = this.daoModule == null ? new DatarouterTraceDaoModule(this.enableTraceLocal, this.enableTracePublisher, this.localTraceClientId, this.localTraceQueueClientId, this.publishingTraceQueueClientId) : this.daoModule;
            return new DatarouterTracePlugin(this.enableTraceLocal, this.enableTracePublisher, module, this.tracePublisher, this.addLocalVacuumJobs, this.traceUrlBuilder);
        }
    }
}

