/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.conveyor;

import io.datarouter.conveyor.MemoryBuffer;
import io.datarouter.instrumentation.trace.Trace2BundleAndHttpRequestRecordDto;
import io.datarouter.storage.setting.Setting;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTrace2FilterToMemoryBuffer {
    private static final Logger logger = LoggerFactory.getLogger(BaseTrace2FilterToMemoryBuffer.class);
    private static final int MAX_TRACES = 1000;
    public final MemoryBuffer<Trace2BundleAndHttpRequestRecordDto> buffer;
    private final Setting<Boolean> shouldRunSetting;

    public BaseTrace2FilterToMemoryBuffer(String bufferName, Setting<Boolean> shouldRun) {
        this.buffer = new MemoryBuffer(bufferName, 1000);
        this.shouldRunSetting = shouldRun;
    }

    public Optional<String> offer(Trace2BundleAndHttpRequestRecordDto dto) {
        return this.offerDtoToBuffer(dto);
    }

    private Optional<String> offerDtoToBuffer(Trace2BundleAndHttpRequestRecordDto dto) {
        if (!((Boolean)this.shouldRunSetting.get()).booleanValue()) {
            return Optional.empty();
        }
        if (!this.buffer.offer((Object)dto)) {
            logger.warn("error offering trace entity buffer={} traceId={}", (Object)this.buffer.getName(), (Object)dto.traceBundleDto.traceDto.getTraceparent());
            return Optional.empty();
        }
        return Optional.of(this.buffer.getName());
    }
}

