/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.conveyor;

import com.google.gson.Gson;
import io.datarouter.conveyor.BaseConveyor;
import io.datarouter.conveyor.Conveyor;
import io.datarouter.conveyor.ConveyorCounters;
import io.datarouter.conveyor.MemoryBuffer;
import io.datarouter.conveyor.message.ConveyorMessage;
import io.datarouter.instrumentation.trace.TraceEntityDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.exception.ExceptionRecorder;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTraceMemoryToSqsConveyor
extends BaseConveyor {
    private static final Logger logger = LoggerFactory.getLogger(BaseTraceMemoryToSqsConveyor.class);
    private static final int BATCH_SIZE = 100;
    private final MemoryBuffer<TraceEntityDto> buffer;
    private final Gson gson;

    public BaseTraceMemoryToSqsConveyor(String name, Supplier<Boolean> shouldRun, MemoryBuffer<TraceEntityDto> buffer, Gson gson, ExceptionRecorder exceptionRecorder) {
        super(name, shouldRun, () -> false, exceptionRecorder);
        this.buffer = buffer;
        this.gson = gson;
    }

    public abstract void processTraceEntityDtos(List<TraceEntityDto> var1);

    public BaseConveyor.ProcessBatchResult processBatch() {
        List dtos = this.buffer.pollMultiWithLimit(100);
        if (dtos.isEmpty()) {
            return new BaseConveyor.ProcessBatchResult(false);
        }
        try {
            this.processTraceEntityDtos(dtos);
            ConveyorCounters.incPutMultiOpAndDatabeans((Conveyor)this, (long)dtos.size());
            return new BaseConveyor.ProcessBatchResult(true);
        }
        catch (RuntimeException putMultiException) {
            List ids = Scanner.of((Iterable)dtos).map(dto -> dto.traceDto.getTraceId()).list();
            logger.warn("exception sending trace to sqs ids={}", (Object)ids, (Object)putMultiException);
            ConveyorCounters.inc((Conveyor)this, (String)"putMulti exception", (long)1L);
            return new BaseConveyor.ProcessBatchResult(false);
        }
    }

    protected ConveyorMessage toMessage(TraceEntityDto dto) {
        return new ConveyorMessage(dto.traceDto.getTraceId(), this.gson.toJson((Object)dto));
    }
}

