/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.conveyor;

import com.google.gson.Gson;
import io.datarouter.conveyor.BaseConveyor;
import io.datarouter.conveyor.Conveyor;
import io.datarouter.conveyor.ConveyorCounters;
import io.datarouter.conveyor.MemoryBuffer;
import io.datarouter.conveyor.message.ConveyorMessage;
import io.datarouter.instrumentation.trace.Trace2BundleAndHttpRequestRecordDto;
import io.datarouter.scanner.OptionalScanner;
import io.datarouter.scanner.Scanner;
import io.datarouter.trace.storage.BaseTrace2HttpRequestRecordQueueDao;
import io.datarouter.trace.storage.BaseTraceQueueDao;
import io.datarouter.web.exception.ExceptionRecorder;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Trace2MemoryBufferToSqsConveyor
extends BaseConveyor {
    private static final Logger logger = LoggerFactory.getLogger(Trace2MemoryBufferToSqsConveyor.class);
    private static final int BATCH_SIZE = 100;
    private final Supplier<Boolean> shouldBufferInSqs;
    private final BaseTraceQueueDao traceQueueDao;
    private final BaseTrace2HttpRequestRecordQueueDao traceHttpReqeustRecordDao;
    private final MemoryBuffer<Trace2BundleAndHttpRequestRecordDto> buffer;
    private final Gson gson;

    public Trace2MemoryBufferToSqsConveyor(String name, Supplier<Boolean> shouldRun, Supplier<Boolean> shouldBufferInSqs, MemoryBuffer<Trace2BundleAndHttpRequestRecordDto> buffer, BaseTraceQueueDao traceQueueDao, BaseTrace2HttpRequestRecordQueueDao traceHttpReqeustRecordDao, Gson gson, ExceptionRecorder exceptionRecorder) {
        super(name, shouldRun, () -> false, exceptionRecorder);
        this.shouldBufferInSqs = shouldBufferInSqs;
        this.traceQueueDao = traceQueueDao;
        this.traceHttpReqeustRecordDao = traceHttpReqeustRecordDao;
        this.buffer = buffer;
        this.gson = gson;
    }

    public void processTraceEntityDtos(List<Trace2BundleAndHttpRequestRecordDto> dtos) {
        if (this.shouldBufferInSqs.get().booleanValue()) {
            Scanner.of(dtos).map(this::toTrace2Message).flush(this.traceQueueDao::putMulti);
            Scanner.of(dtos).map(this::toHttpReqRecordMessage).concat(OptionalScanner::of).flush(this.traceHttpReqeustRecordDao::putMulti);
        }
    }

    public BaseConveyor.ProcessBatchResult processBatch() {
        List dtos = this.buffer.pollMultiWithLimit(100);
        if (dtos.isEmpty()) {
            return new BaseConveyor.ProcessBatchResult(false);
        }
        try {
            this.processTraceEntityDtos(dtos);
            ConveyorCounters.incPutMultiOpAndDatabeans((Conveyor)this, (long)dtos.size());
            return new BaseConveyor.ProcessBatchResult(true);
        }
        catch (RuntimeException putMultiException) {
            List ids = Scanner.of((Iterable)dtos).map(Trace2BundleAndHttpRequestRecordDto::getTraceparent).list();
            logger.warn("exception sending trace to sqs ids={}", (Object)ids, (Object)putMultiException);
            ConveyorCounters.inc((Conveyor)this, (String)"putMulti exception", (long)1L);
            return new BaseConveyor.ProcessBatchResult(false);
        }
    }

    protected ConveyorMessage toTrace2Message(Trace2BundleAndHttpRequestRecordDto dto) {
        return new ConveyorMessage(dto.getTraceparent().toString(), this.gson.toJson((Object)dto.traceBundleDto));
    }

    protected Optional<ConveyorMessage> toHttpReqRecordMessage(Trace2BundleAndHttpRequestRecordDto dto) {
        if (dto.httpRequestRecord == null) {
            return Optional.empty();
        }
        return Optional.of(new ConveyorMessage(dto.getTraceparent().toString(), this.gson.toJson((Object)dto.httpRequestRecord)));
    }
}

