/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.conveyor.local;

import com.google.gson.Gson;
import io.datarouter.conveyor.message.ConveyorMessage;
import io.datarouter.conveyor.message.ConveyorMessageKey;
import io.datarouter.conveyor.queue.GroupQueueConsumer;
import io.datarouter.instrumentation.trace.Trace2BatchedBundleDto;
import io.datarouter.instrumentation.trace.Trace2BundleDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.trace.conveyor.BaseTrace2SqsDrainConveyor;
import io.datarouter.trace.storage.Trace2ForLocalDao;
import io.datarouter.trace.storage.span.Trace2Span;
import io.datarouter.trace.storage.thread.Trace2Thread;
import io.datarouter.trace.storage.trace.Trace2;
import io.datarouter.web.exception.ExceptionRecorder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class Trace2ForLocalSqsDrainConveyor
extends BaseTrace2SqsDrainConveyor {
    private final Trace2ForLocalDao traceDao;

    public Trace2ForLocalSqsDrainConveyor(String name, Supplier<Boolean> shouldRun, GroupQueueConsumer<ConveyorMessageKey, ConveyorMessage> groupQueueConsumer, Gson gson, Trace2ForLocalDao traceDao, Supplier<Boolean> compactExceptionLogging, ExceptionRecorder exceptionRecorder) {
        super(name, shouldRun, groupQueueConsumer, compactExceptionLogging, gson, exceptionRecorder);
        this.traceDao = traceDao;
    }

    @Override
    public void persistData(Trace2BatchedBundleDto batchDto) {
        for (Trace2BundleDto dto : batchDto.batch) {
            ArrayList<Trace2> traces = new ArrayList<Trace2>();
            if (dto.traceDto != null) {
                traces.add(new Trace2("default", dto.traceDto));
            }
            List threads = Scanner.of((Iterable)dto.traceThreadDtos).map(Trace2Thread::new).list();
            List spans = Scanner.of((Iterable)dto.traceSpanDtos).map(Trace2Span::new).list();
            this.traceDao.putMultiTraceBundles(threads, spans, traces);
        }
    }
}

