/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.conveyor.local;

import io.datarouter.conveyor.MemoryBuffer;
import io.datarouter.instrumentation.trace.TraceEntityDto;
import io.datarouter.trace.conveyor.TraceToFilterBufferTool;
import io.datarouter.trace.conveyor.local.FilterToMemoryBufferForLocal;
import io.datarouter.trace.settings.DatarouterTraceLocalSettingRoot;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TraceLocalFilterToMemoryBuffer
implements FilterToMemoryBufferForLocal {
    private static final int MAX_TRACES = 1000;
    public final MemoryBuffer<TraceEntityDto> buffer;
    private final DatarouterTraceLocalSettingRoot settings;

    @Inject
    public TraceLocalFilterToMemoryBuffer(DatarouterTraceLocalSettingRoot settings) {
        this.settings = settings;
        this.buffer = new MemoryBuffer("localTraceBuffer", 1000);
    }

    @Override
    public Optional<String> offer(TraceEntityDto dto) {
        return TraceToFilterBufferTool.offerDtoToBuffer((Boolean)this.settings.runMemoryToSqs.get(), this.buffer, dto);
    }
}

