/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.conveyor.local;

import com.google.gson.Gson;
import io.datarouter.conveyor.MemoryBuffer;
import io.datarouter.instrumentation.trace.TraceEntityDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.setting.Setting;
import io.datarouter.trace.conveyor.BaseTraceMemoryToSqsConveyor;
import io.datarouter.trace.storage.BaseDatarouterTraceDao;
import io.datarouter.trace.storage.BaseTraceQueueDao;
import io.datarouter.trace.storage.span.TraceSpan;
import io.datarouter.trace.storage.thread.TraceThread;
import io.datarouter.trace.storage.trace.Trace;
import io.datarouter.web.exception.ExceptionRecorder;
import java.util.List;
import java.util.function.Supplier;

public class TraceMemoryToSqsConveyor
extends BaseTraceMemoryToSqsConveyor {
    private final Setting<Boolean> shouldBufferInSqs;
    private final BaseTraceQueueDao traceQueueDao;
    private final BaseDatarouterTraceDao traceDao;

    public TraceMemoryToSqsConveyor(String name, Setting<Boolean> shouldRunSetting, Setting<Boolean> shouldBufferInSqs, MemoryBuffer<TraceEntityDto> buffer, BaseTraceQueueDao traceQueueDao, BaseDatarouterTraceDao traceDao, Gson gson, ExceptionRecorder exceptionRecorder) {
        super(name, (Supplier<Boolean>)shouldRunSetting, buffer, gson, exceptionRecorder);
        this.shouldBufferInSqs = shouldBufferInSqs;
        this.traceQueueDao = traceQueueDao;
        this.traceDao = traceDao;
    }

    @Override
    public void processTraceEntityDtos(List<TraceEntityDto> dtos) {
        if (((Boolean)this.shouldBufferInSqs.get()).booleanValue()) {
            Scanner.of(dtos).map(this::toMessage).flush(this.traceQueueDao::putMulti);
        } else {
            for (TraceEntityDto dto : dtos) {
                this.traceDao.putMulti(Scanner.of((Iterable)dto.traceThreadDtos).map(TraceThread::new).list(), Scanner.of((Iterable)dto.traceSpanDtos).map(TraceSpan::new).list(), new Trace(dto.traceDto));
            }
        }
    }
}

