/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.conveyor.local;

import com.google.gson.Gson;
import io.datarouter.conveyor.message.ConveyorMessage;
import io.datarouter.conveyor.message.ConveyorMessageKey;
import io.datarouter.conveyor.queue.BaseGroupQueueConsumerConveyor;
import io.datarouter.conveyor.queue.GroupQueueConsumer;
import io.datarouter.instrumentation.trace.TraceEntityDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.trace.storage.BaseDatarouterTraceDao;
import io.datarouter.trace.storage.span.TraceSpan;
import io.datarouter.trace.storage.thread.TraceThread;
import io.datarouter.trace.storage.trace.Trace;
import io.datarouter.web.exception.ExceptionRecorder;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;

public class TraceSqsDrainConveyor
extends BaseGroupQueueConsumerConveyor<ConveyorMessageKey, ConveyorMessage> {
    private final Gson gson;
    private final BaseDatarouterTraceDao traceDao;

    public TraceSqsDrainConveyor(String name, Supplier<Boolean> shouldRun, GroupQueueConsumer<ConveyorMessageKey, ConveyorMessage> groupQueueConsumer, BaseDatarouterTraceDao traceDao, Gson gson, ExceptionRecorder exceptionRecorder) {
        super(name, shouldRun, groupQueueConsumer, () -> false, Duration.ofSeconds(30L), exceptionRecorder);
        this.gson = gson;
        this.traceDao = traceDao;
    }

    protected void processDatabeans(List<ConveyorMessage> traceEntity) {
        traceEntity.forEach(this::persistEntity);
    }

    private void persistEntity(ConveyorMessage message) {
        TraceEntityDto dto = (TraceEntityDto)this.gson.fromJson(message.getMessage(), TraceEntityDto.class);
        Trace trace = new Trace(dto.traceDto);
        List threads = Scanner.of((Iterable)dto.traceThreadDtos).map(TraceThread::new).list();
        List spans = Scanner.of((Iterable)dto.traceSpanDtos).map(TraceSpan::new).list();
        this.traceDao.putMulti(threads, spans, trace);
    }
}

