/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.conveyor.publisher;

import io.datarouter.conveyor.MemoryBuffer;
import io.datarouter.instrumentation.trace.TraceEntityDto;
import io.datarouter.trace.conveyor.TraceToFilterBufferTool;
import io.datarouter.trace.conveyor.publisher.FilterToMemoryBufferForPublisher;
import io.datarouter.trace.settings.DatarouterTracePublisherSettingRoot;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TracePublisherFilterToMemoryBuffer
implements FilterToMemoryBufferForPublisher {
    private static final int MAX_TRACES = 1000;
    public final MemoryBuffer<TraceEntityDto> buffer;
    private final DatarouterTracePublisherSettingRoot settings;

    @Inject
    public TracePublisherFilterToMemoryBuffer(DatarouterTracePublisherSettingRoot settings) {
        this.settings = settings;
        this.buffer = new MemoryBuffer("publisherTraceBuffer", 1000);
    }

    @Override
    public Optional<String> offer(TraceEntityDto dto) {
        return TraceToFilterBufferTool.offerDtoToBuffer((Boolean)this.settings.runMemoryToSqs.get(), this.buffer, dto);
    }
}

