/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.conveyor.publisher;

import com.google.gson.Gson;
import io.datarouter.conveyor.message.ConveyorMessage;
import io.datarouter.conveyor.message.ConveyorMessageKey;
import io.datarouter.conveyor.queue.BaseGroupQueueConsumerConveyor;
import io.datarouter.conveyor.queue.GroupQueueConsumer;
import io.datarouter.instrumentation.response.PublishingResponseDto;
import io.datarouter.instrumentation.trace.TraceEntityBatchDto;
import io.datarouter.instrumentation.trace.TraceEntityDto;
import io.datarouter.instrumentation.trace.TracePublisher;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.exception.ExceptionRecorder;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;

public class TraceSqsDrainConveyorPublisher
extends BaseGroupQueueConsumerConveyor<ConveyorMessageKey, ConveyorMessage> {
    private final Gson gson;
    private final TracePublisher tracePublisher;

    public TraceSqsDrainConveyorPublisher(String name, Supplier<Boolean> shouldRun, GroupQueueConsumer<ConveyorMessageKey, ConveyorMessage> groupQueueConsumer, Gson gson, TracePublisher tracePublisher, Supplier<Boolean> compactExceptionLogging, ExceptionRecorder exceptionRecorder) {
        super(name, shouldRun, groupQueueConsumer, compactExceptionLogging, Duration.ofSeconds(30L), exceptionRecorder);
        this.gson = gson;
        this.tracePublisher = tracePublisher;
    }

    protected void processDatabeans(List<ConveyorMessage> databeans) {
        TraceEntityBatchDto dto = (TraceEntityBatchDto)Scanner.of(databeans).map(ConveyorMessage::getMessage).map(message -> (TraceEntityDto)this.gson.fromJson(message, TraceEntityDto.class)).listTo(TraceEntityBatchDto::new);
        PublishingResponseDto response = this.tracePublisher.add(dto);
        if (response.success == null || !response.success.booleanValue()) {
            throw new RuntimeException("failed to publish response=" + response.message);
        }
    }
}

