/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.trace.filter;

import com.sun.management.ThreadMXBean;
import io.datarouter.httpclient.client.DatarouterService;
import io.datarouter.inject.DatarouterInjector;
import io.datarouter.instrumentation.exception.HttpRequestRecordDto;
import io.datarouter.instrumentation.trace.Trace2BundleAndHttpRequestRecordDto;
import io.datarouter.instrumentation.trace.Trace2BundleDto;
import io.datarouter.instrumentation.trace.Trace2Dto;
import io.datarouter.instrumentation.trace.Trace2SpanDto;
import io.datarouter.instrumentation.trace.Trace2ThreadDto;
import io.datarouter.instrumentation.trace.TraceContextFlagTool;
import io.datarouter.instrumentation.trace.TraceDto;
import io.datarouter.instrumentation.trace.TraceEntityDto;
import io.datarouter.instrumentation.trace.TraceSpanDto;
import io.datarouter.instrumentation.trace.TraceThreadDto;
import io.datarouter.instrumentation.trace.Traceparent;
import io.datarouter.instrumentation.trace.Tracer;
import io.datarouter.instrumentation.trace.TracerThreadLocal;
import io.datarouter.instrumentation.trace.W3TraceContext;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.DatarouterProperties;
import io.datarouter.trace.conveyor.local.FilterToMemoryBufferForLocal;
import io.datarouter.trace.conveyor.local.Trace2ForLocalFilterToMemoryBuffer;
import io.datarouter.trace.conveyor.publisher.FilterToMemoryBufferForPublisher;
import io.datarouter.trace.conveyor.publisher.Trace2ForPublisherFilterToMemoryBuffer;
import io.datarouter.trace.service.TraceUrlBuilder;
import io.datarouter.trace.settings.DatarouterTraceFilterSettingRoot;
import io.datarouter.util.UlidTool;
import io.datarouter.util.UuidTool;
import io.datarouter.util.array.ArrayTool;
import io.datarouter.util.serialization.GsonTool;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.tracer.DatarouterTracer;
import io.datarouter.web.dispatcher.Dispatcher;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.HandlerMetrics;
import io.datarouter.web.inject.InjectorRetriever;
import io.datarouter.web.user.session.CurrentSessionInfo;
import io.datarouter.web.user.session.service.Session;
import io.datarouter.web.util.RequestAttributeKey;
import io.datarouter.web.util.RequestAttributeTool;
import io.datarouter.web.util.http.RecordedHttpHeaders;
import io.datarouter.web.util.http.RequestTool;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TraceFilter
implements Filter,
InjectorRetriever {
    private static final Logger logger = LoggerFactory.getLogger(TraceFilter.class);
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getPlatformMXBean(ThreadMXBean.class);
    private DatarouterProperties datarouterProperties;
    private DatarouterTraceFilterSettingRoot traceSettings;
    private FilterToMemoryBufferForLocal traceBufferForLocal;
    private Trace2ForLocalFilterToMemoryBuffer trace2BufferForLocal;
    private FilterToMemoryBufferForPublisher traceBufferForPublisher;
    private Trace2ForPublisherFilterToMemoryBuffer trace2BufferForPublisher;
    private TraceUrlBuilder urlBuilder;
    private CurrentSessionInfo currentSessionInfo;
    private HandlerMetrics handlerMetrics;
    private DatarouterService datarouterService;

    public void init(FilterConfig filterConfig) {
        DatarouterInjector injector = this.getInjector(filterConfig.getServletContext());
        this.datarouterProperties = (DatarouterProperties)injector.getInstance(DatarouterProperties.class);
        this.traceBufferForLocal = (FilterToMemoryBufferForLocal)injector.getInstance(FilterToMemoryBufferForLocal.class);
        this.trace2BufferForLocal = (Trace2ForLocalFilterToMemoryBuffer)injector.getInstance(Trace2ForLocalFilterToMemoryBuffer.class);
        this.traceBufferForPublisher = (FilterToMemoryBufferForPublisher)injector.getInstance(FilterToMemoryBufferForPublisher.class);
        this.trace2BufferForPublisher = (Trace2ForPublisherFilterToMemoryBuffer)injector.getInstance(Trace2ForPublisherFilterToMemoryBuffer.class);
        this.traceSettings = (DatarouterTraceFilterSettingRoot)((Object)injector.getInstance(DatarouterTraceFilterSettingRoot.class));
        this.urlBuilder = (TraceUrlBuilder)injector.getInstance(TraceUrlBuilder.class);
        this.currentSessionInfo = (CurrentSessionInfo)injector.getInstance(CurrentSessionInfo.class);
        this.handlerMetrics = (HandlerMetrics)injector.getInstance(HandlerMetrics.class);
        this.datarouterService = (DatarouterService)injector.getInstance(DatarouterService.class);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException, ServletException {
        try {
            Long cpuTime;
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            String traceId = UlidTool.nextUlid();
            RequestAttributeTool.set((ServletRequest)request, (RequestAttributeKey)BaseHandler.TRACE_URL_REQUEST_ATTRIBUTE, (Object)this.urlBuilder.buildTraceForCurrentServer(traceId));
            if (((Boolean)this.traceSettings.addTraceIdHeader.get()).booleanValue()) {
                response.setHeader("x-trace-id", traceId);
            }
            Long created = Trace2Dto.getCurrentTimeInNs();
            TraceDto trace = new TraceDto(traceId, created);
            trace.setContext(request.getContextPath());
            trace.setType(request.getRequestURI().toString());
            trace.setParams(request.getQueryString());
            String traceparent = request.getHeader("traceparent");
            String tracestate = request.getHeader("tracestate");
            W3TraceContext traceContext = new W3TraceContext(traceparent, tracestate, created.longValue());
            String initialParentId = traceContext.getTraceparent().parentId;
            traceContext.updateParentIdAndAddTracestateMember();
            RequestAttributeTool.set((ServletRequest)request, (RequestAttributeKey)BaseHandler.TRACE_CONTEXT, (Object)traceContext.copy());
            String serverName = this.datarouterProperties.getServerName();
            DatarouterTracer tracer = new DatarouterTracer(serverName, traceId, null, traceContext);
            TracerThreadLocal.bindToThread((Tracer)tracer);
            String requestThreadName = (String.valueOf(request.getContextPath()) + " request").trim();
            tracer.createAndStartThread(requestThreadName, Trace2Dto.getCurrentTimeInNs());
            Long threadId = Thread.currentThread().getId();
            boolean logCpuTime = (Boolean)this.traceSettings.logCpuTime.get();
            Long cpuTimeBegin = logCpuTime ? Long.valueOf(THREAD_MX_BEAN.getThreadCpuTime(threadId)) : null;
            boolean logAllocatedBytes = (Boolean)this.traceSettings.logAllocatedBytes.get();
            Long threadAllocatedBytesBegin = logAllocatedBytes ? Long.valueOf(THREAD_MX_BEAN.getThreadAllocatedBytes(threadId)) : null;
            boolean errored = false;
            try {
                try {
                    fc.doFilter(req, res);
                }
                catch (Exception e) {
                    errored = true;
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Long cpuTime2;
                Long l = cpuTime2 = logCpuTime ? Long.valueOf(THREAD_MX_BEAN.getThreadCpuTime(threadId) - cpuTimeBegin) : null;
                if (cpuTime2 != null) {
                    cpuTime2 = TimeUnit.NANOSECONDS.toMillis(cpuTime2);
                }
                Long threadAllocatedKB = logAllocatedBytes ? Long.valueOf((THREAD_MX_BEAN.getThreadAllocatedBytes(threadId) - threadAllocatedBytesBegin) / 1024L) : null;
                TraceThreadDto rootThread = null;
                if (tracer.getCurrentThreadId() != null) {
                    rootThread = tracer.getCurrentThread();
                    rootThread.markFinish();
                    tracer.setCurrentThread(null);
                }
                trace.markFinished();
                Trace2Dto trace2Dto = this.createTrace2Dto(traceContext, initialParentId, request, created, (Tracer)tracer);
                Long traceDurationMs = trace.getDurationMs();
                if (((Boolean)this.traceSettings.saveTraces.get()).booleanValue() && traceDurationMs > (long)((Integer)this.traceSettings.saveTracesOverMs.get()).intValue() || RequestTool.getBoolean((HttpServletRequest)request, (String)"trace", (Boolean)false).booleanValue() || tracer.getForceSave() || errored || TraceContextFlagTool.shouldSample()) {
                    ArrayList<TraceThreadDto> threads = new ArrayList<TraceThreadDto>(tracer.getThreadQueue());
                    if (rootThread != null) {
                        threads.add(rootThread);
                    }
                    ArrayList<TraceSpanDto> spans = new ArrayList<TraceSpanDto>(tracer.getSpanQueue());
                    trace.setDiscardedThreadCount(tracer.getDiscardedThreadCount());
                    String userAgent = RequestTool.getUserAgent((HttpServletRequest)request);
                    String userToken = this.currentSessionInfo.getSession((ServletRequest)request).map(Session::getUserToken).orElse("unknown");
                    TraceEntityDto entityDto = new TraceEntityDto(trace, threads, spans);
                    String destination = this.offer(entityDto);
                    List<Trace2ThreadDto> trace2Threads = this.convertToTrace2Thread(threads, traceContext.getTraceparent(), spans.size());
                    List<Trace2SpanDto> trace2Spans = this.convertToTrace2Span(spans, traceContext.getTraceparent());
                    HttpRequestRecordDto httpRequestRecord = this.buildHttpRequestRecord(errored, request, created, userToken, traceContext.getTraceparent());
                    String destination2 = this.offerTrace2(new Trace2BundleDto(trace2Dto, trace2Threads, trace2Spans), httpRequestRecord);
                    logger.warn("Trace saved to={} traceId={} traceparent={} initialParentId={} durationMs={} cpuTimeMs={} threadAllocatedKB={} path={} query={} userAgent=\"{}\" userToken={}", new Object[]{String.join((CharSequence)",", destination, destination2), trace.getTraceId(), traceContext.getTraceparent(), initialParentId, traceDurationMs, cpuTime2, threadAllocatedKB, trace.getType(), trace.getParams(), userAgent, userToken});
                } else if (traceDurationMs > (long)((Integer)this.traceSettings.logTracesOverMs.get()).intValue() || TraceContextFlagTool.shouldLog()) {
                    logger.warn("Trace logged durationMs={} cpuTimeMs={} threadAllocatedKB={} path={} query={}, traceContext={}", new Object[]{traceDurationMs, cpuTime2, threadAllocatedKB, trace.getType(), trace.getParams(), traceContext});
                }
                Optional handlerClassOpt = RequestAttributeTool.get((ServletRequest)request, (RequestAttributeKey)BaseHandler.HANDLER_CLASS);
                Optional handlerMethodOpt = RequestAttributeTool.get((ServletRequest)request, (RequestAttributeKey)BaseHandler.HANDLER_METHOD);
                if (handlerClassOpt.isPresent() && handlerMethodOpt.isPresent()) {
                    Class handlerClass = (Class)handlerClassOpt.get();
                    if (((Set)this.traceSettings.latencyRecordedHandlers.get()).contains(handlerClass.getName())) {
                        this.handlerMetrics.saveMethodLatency(handlerClass, (Method)handlerMethodOpt.get(), traceDurationMs.longValue());
                    }
                }
                throw throwable;
            }
            Long l = cpuTime = logCpuTime ? Long.valueOf(THREAD_MX_BEAN.getThreadCpuTime(threadId) - cpuTimeBegin) : null;
            if (cpuTime != null) {
                cpuTime = TimeUnit.NANOSECONDS.toMillis(cpuTime);
            }
            Long threadAllocatedKB = logAllocatedBytes ? Long.valueOf((THREAD_MX_BEAN.getThreadAllocatedBytes(threadId) - threadAllocatedBytesBegin) / 1024L) : null;
            TraceThreadDto rootThread = null;
            if (tracer.getCurrentThreadId() != null) {
                rootThread = tracer.getCurrentThread();
                rootThread.markFinish();
                tracer.setCurrentThread(null);
            }
            trace.markFinished();
            Trace2Dto trace2Dto = this.createTrace2Dto(traceContext, initialParentId, request, created, (Tracer)tracer);
            Long traceDurationMs = trace.getDurationMs();
            if (((Boolean)this.traceSettings.saveTraces.get()).booleanValue() && traceDurationMs > (long)((Integer)this.traceSettings.saveTracesOverMs.get()).intValue() || RequestTool.getBoolean((HttpServletRequest)request, (String)"trace", (Boolean)false).booleanValue() || tracer.getForceSave() || errored || TraceContextFlagTool.shouldSample()) {
                ArrayList<TraceThreadDto> threads = new ArrayList<TraceThreadDto>(tracer.getThreadQueue());
                if (rootThread != null) {
                    threads.add(rootThread);
                }
                ArrayList<TraceSpanDto> spans = new ArrayList<TraceSpanDto>(tracer.getSpanQueue());
                trace.setDiscardedThreadCount(tracer.getDiscardedThreadCount());
                String userAgent = RequestTool.getUserAgent((HttpServletRequest)request);
                String userToken = this.currentSessionInfo.getSession((ServletRequest)request).map(Session::getUserToken).orElse("unknown");
                TraceEntityDto entityDto = new TraceEntityDto(trace, threads, spans);
                String destination = this.offer(entityDto);
                List<Trace2ThreadDto> trace2Threads = this.convertToTrace2Thread(threads, traceContext.getTraceparent(), spans.size());
                List<Trace2SpanDto> trace2Spans = this.convertToTrace2Span(spans, traceContext.getTraceparent());
                HttpRequestRecordDto httpRequestRecord = this.buildHttpRequestRecord(errored, request, created, userToken, traceContext.getTraceparent());
                String destination2 = this.offerTrace2(new Trace2BundleDto(trace2Dto, trace2Threads, trace2Spans), httpRequestRecord);
                logger.warn("Trace saved to={} traceId={} traceparent={} initialParentId={} durationMs={} cpuTimeMs={} threadAllocatedKB={} path={} query={} userAgent=\"{}\" userToken={}", new Object[]{String.join((CharSequence)",", destination, destination2), trace.getTraceId(), traceContext.getTraceparent(), initialParentId, traceDurationMs, cpuTime, threadAllocatedKB, trace.getType(), trace.getParams(), userAgent, userToken});
            } else if (traceDurationMs > (long)((Integer)this.traceSettings.logTracesOverMs.get()).intValue() || TraceContextFlagTool.shouldLog()) {
                logger.warn("Trace logged durationMs={} cpuTimeMs={} threadAllocatedKB={} path={} query={}, traceContext={}", new Object[]{traceDurationMs, cpuTime, threadAllocatedKB, trace.getType(), trace.getParams(), traceContext});
            }
            Optional handlerClassOpt = RequestAttributeTool.get((ServletRequest)request, (RequestAttributeKey)BaseHandler.HANDLER_CLASS);
            Optional handlerMethodOpt = RequestAttributeTool.get((ServletRequest)request, (RequestAttributeKey)BaseHandler.HANDLER_METHOD);
            if (handlerClassOpt.isPresent() && handlerMethodOpt.isPresent()) {
                Class handlerClass = (Class)handlerClassOpt.get();
                if (((Set)this.traceSettings.latencyRecordedHandlers.get()).contains(handlerClass.getName())) {
                    this.handlerMetrics.saveMethodLatency(handlerClass, (Method)handlerMethodOpt.get(), traceDurationMs.longValue());
                }
            }
        }
        finally {
            TracerThreadLocal.clearFromThread();
        }
    }

    private HttpRequestRecordDto buildHttpRequestRecord(boolean errored, HttpServletRequest request, Long receivedAt, String userToken, Traceparent traceparent) {
        if (errored) {
            return null;
        }
        receivedAt = TimeUnit.NANOSECONDS.toMillis(receivedAt);
        long created = TimeUnit.NANOSECONDS.toMillis(Trace2Dto.getCurrentTimeInNs());
        RecordedHttpHeaders headersWrapper = new RecordedHttpHeaders(request);
        return new HttpRequestRecordDto(UuidTool.generateV1Uuid(), new Date(created), new Date(receivedAt), Long.valueOf(created - receivedAt), null, traceparent.traceId, traceparent.parentId, request.getMethod(), GsonTool.GSON.toJson((Object)request.getParameterMap()), request.getScheme(), request.getServerName(), request.getServerPort(), request.getContextPath(), TraceFilter.getRequestPath(request), request.getQueryString(), TraceFilter.getBinaryBody(request), RequestTool.getIpAddress((HttpServletRequest)request), this.currentSessionInfo.getRoles((ServletRequest)request).toString(), userToken, headersWrapper.getAcceptCharset(), headersWrapper.getAcceptEncoding(), headersWrapper.getAcceptLanguage(), headersWrapper.getAccept(), headersWrapper.getCacheControl(), headersWrapper.getConnection(), headersWrapper.getContentEncoding(), headersWrapper.getContentLanguage(), headersWrapper.getContentLength(), headersWrapper.getContentType(), headersWrapper.getCookie(), headersWrapper.getDnt(), headersWrapper.getHost(), headersWrapper.getIfModifiedSince(), headersWrapper.getOrigin(), headersWrapper.getPragma(), headersWrapper.getReferer(), headersWrapper.getUserAgent(), headersWrapper.getXForwardedFor(), headersWrapper.getXRequestedWith(), headersWrapper.getOthers());
    }

    private static String getRequestPath(HttpServletRequest request) {
        String requestUri = request.getRequestURI();
        return requestUri == null ? "" : requestUri.substring(StringTool.nullSafe((String)request.getContextPath()).length());
    }

    private static byte[] getBinaryBody(HttpServletRequest request) {
        if (RequestAttributeTool.get((ServletRequest)request, (RequestAttributeKey)Dispatcher.TRANSMITS_PII).orElse(false).booleanValue()) {
            return HttpRequestRecordDto.CONFIDENTIALITY_MSG_BYTES;
        }
        byte[] binaryBody = RequestTool.tryGetBodyAsByteArray((ServletRequest)request);
        int originalLength = binaryBody.length;
        return originalLength > 10000 ? ArrayTool.trimToSize((byte[])binaryBody, (int)10000) : binaryBody;
    }

    private String offer(TraceEntityDto dto) {
        return Stream.of(this.traceBufferForLocal.offer(dto), this.traceBufferForPublisher.offer(dto)).flatMap(Optional::stream).collect(Collectors.joining(", "));
    }

    private String offerTrace2(Trace2BundleDto traceBundle, HttpRequestRecordDto httpRequestRecord) {
        Trace2BundleAndHttpRequestRecordDto traceAndHttpRequest = new Trace2BundleAndHttpRequestRecordDto(traceBundle, httpRequestRecord);
        return Stream.of(this.trace2BufferForLocal.offer(traceAndHttpRequest), this.trace2BufferForPublisher.offer(traceAndHttpRequest)).flatMap(Optional::stream).collect(Collectors.joining(", "));
    }

    private Trace2Dto createTrace2Dto(W3TraceContext traceContext, String initialParentId, HttpServletRequest request, Long created, Tracer tracer) {
        return new Trace2Dto(traceContext.getTraceparent(), initialParentId, request.getContextPath(), request.getRequestURI().toString(), request.getQueryString(), created, this.datarouterService.getServiceName(), tracer.getDiscardedThreadCount(), Integer.valueOf(tracer.getThreadQueue().size()));
    }

    private List<Trace2ThreadDto> convertToTrace2Thread(List<TraceThreadDto> threads, Traceparent traceparent, int numSpans) {
        return Scanner.of(threads).map(thread -> new Trace2ThreadDto(traceparent, thread.getThreadId(), thread.getParentId(), thread.getName(), thread.getInfo(), thread.getServerId(), thread.getCreated(), thread.getQueuedEnded(), thread.getEnded(), thread.getDiscardedSpanCount(), thread.getHostThreadName(), Integer.valueOf(numSpans))).list();
    }

    private List<Trace2SpanDto> convertToTrace2Span(List<TraceSpanDto> spans, Traceparent traceparent) {
        return Scanner.of(spans).map(span -> new Trace2SpanDto(traceparent, span.getThreadId(), span.getSequence(), span.getParentSequence(), span.getName(), span.getInfo(), span.getCreated(), span.getEnded())).list();
    }
}

